/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.ntp;

import java.util.Map;
import me.val_mobile.data.ModuleItems;
import me.val_mobile.data.ModuleRecipes;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVModule;
import me.val_mobile.ntp.NtpEvents;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;

public class NtpModule
extends RSVModule {
    private final RSVPlugin plugin;
    private NtpEvents events;
    public static final String NAME = "NoTreePunching";

    public NtpModule(RSVPlugin plugin) {
        super(NAME, plugin, Map.of(), Map.of());
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        this.setUserConfig(new RSVConfig(this.plugin, "notreepunching.yml"));
        this.setItemConfig(new RSVConfig(this.plugin, "resources/notreepunching/items.yml"));
        this.setRecipeConfig(new RSVConfig(this.plugin, "resources/notreepunching/recipes.yml"));
        this.setModuleItems(new ModuleItems(this));
        this.setModuleRecipes(new ModuleRecipes(this, this.plugin));
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Initialize.Enabled")) {
            String message = Utils.translateMsg(config.getString("Initialize.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
        this.events = new NtpEvents(this, this.plugin);
        this.getModuleItems().initialize();
        this.getModuleRecipes().initialize();
        this.events.initialize();
        if (config.getBoolean("Lumberjack.RemovePlankRecipes")) {
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "acacia_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "birch_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "crimson_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "dark_oak_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "jungle_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "mangrove_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "oak_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "spruce_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "warped_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "cherry_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "bamboo_planks"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "pale_oak_planks"));
        }
        if (config.getBoolean("Lumberjack.RemoveStickRecipes")) {
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "stick"));
        }
        if (config.getBoolean("FireStarter.RemoveVanillaCampfireRecipes")) {
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "campfire"));
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "soul_campfire"));
        }
        if (config.getBoolean("Pottery.RemoveFlowerPotRecipe")) {
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "flower_pot"));
        }
        if (config.getBoolean("Pottery.RemoveBrickSmeltingRecipe")) {
            Bukkit.removeRecipe((NamespacedKey)new NamespacedKey("minecraft", "brick"));
        }
    }

    @Override
    public void shutdown() {
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Shutdown.Enabled")) {
            String message = Utils.translateMsg(config.getString("Shutdown.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
    }

    public NtpEvents getEvents() {
        return this.events;
    }
}

