/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanandfire;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.val_mobile.rsv.RSVPlugin;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BurnTask
extends BukkitRunnable {
    private static final Map<UUID, BurnTask> tasks = new HashMap<UUID, BurnTask>();
    private final Entity entity;
    private final RSVPlugin plugin;
    private int fireTicks;
    private final int tickPeriod;

    public BurnTask(RSVPlugin plugin, Entity entity, int fireTicks, int tickPeriod) {
        this.entity = entity;
        this.plugin = plugin;
        this.fireTicks = fireTicks;
        this.tickPeriod = tickPeriod;
        tasks.put(entity.getUniqueId(), this);
    }

    public void run() {
        if (this.fireTicks > 0 || this.entity.isDead()) {
            if (this.entity.getFireTicks() < this.fireTicks) {
                this.entity.setFireTicks(this.fireTicks);
                this.fireTicks -= this.tickPeriod;
            }
        } else {
            tasks.remove(this.entity.getUniqueId());
            this.cancel();
        }
    }

    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, this.tickPeriod);
    }

    public static Map<UUID, BurnTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }
}

