/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanandfire;

import java.util.ArrayList;
import me.val_mobile.data.ModuleEvents;
import me.val_mobile.data.RSVModule;
import me.val_mobile.iceandfire.IceFireModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanandfire.SfModule;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SfEvents
extends ModuleEvents
implements Listener {
    private final RSVPlugin plugin;
    private final SfModule module;
    private final FileConfiguration config;

    public SfEvents(SfModule module, RSVPlugin plugin) {
        super(module, plugin);
        this.plugin = plugin;
        this.module = module;
        this.config = module.getUserConfig().getConfig();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        LivingEntity living;
        Entity defender = event.getEntity();
        Entity attacker = event.getDamager();
        if (!this.shouldEventBeRan(attacker) || !this.shouldEventBeRan(defender)) {
            return;
        }
        double damage = event.getDamage();
        if (Utils.hasNbtTag(attacker, "rsvbow")) {
            String name = (String)Utils.getNbtTag(attacker, "rsvbow", PersistentDataType.STRING);
            IceFireModule.applyDragonItemEffect(defender, name, (RSVModule)this.module);
            damage = IceFireModule.applyDragonItemBonusDamage(defender, name, damage, (RSVModule)this.module);
        } else if (attacker instanceof LivingEntity && (living = (LivingEntity)attacker).getEquipment() != null) {
            ItemStack itemMainHand = living.getEquipment().getItemInMainHand();
            IceFireModule.applyDragonItemEffect(defender, itemMainHand, (RSVModule)this.module);
            damage = IceFireModule.applyDragonItemBonusDamage(defender, itemMainHand, damage, (RSVModule)this.module);
        }
        event.setDamage(damage);
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (!this.shouldEventBeRan((Entity)event.getView().getPlayer())) {
            return;
        }
        if (recipe == null) {
            ItemStack[] matrix = event.getInventory().getMatrix();
            ArrayList<ItemStack> rsvItems = new ArrayList<ItemStack>();
            for (ItemStack item : matrix) {
                if (!RSVItem.isRSVItem(item)) continue;
                rsvItems.add(item);
            }
            if (rsvItems.size() == 2) {
                ItemStack dragonBlood;
                ItemStack dragonboneWeapon = switch (RSVItem.getNameFromItem((ItemStack)rsvItems.get(0))) {
                    case "dragon_blood_fire", "dragon_blood_ice", "dragon_blood_lightning" -> {
                        dragonBlood = (ItemStack)rsvItems.get(0);
                        yield (ItemStack)rsvItems.get(1);
                    }
                    default -> {
                        dragonBlood = (ItemStack)rsvItems.get(1);
                        yield (ItemStack)rsvItems.get(0);
                    }
                };
                String dragonBloodName = RSVItem.getNameFromItem(dragonBlood);
                String dragonboneWeaponName = RSVItem.getNameFromItem(dragonboneWeapon);
                switch (dragonBloodName) {
                    case "dragon_blood_fire": 
                    case "dragon_blood_ice": 
                    case "dragon_blood_lightning": {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                switch (dragonboneWeaponName) {
                    case "dragonbone_longbow": 
                    case "dragonbone_rapier": 
                    case "dragonbone_katana": 
                    case "dragonbone_greatsword": 
                    case "dragonbone_longsword": 
                    case "dragonbone_spear": 
                    case "dragonbone_saber": 
                    case "dragonbone_boomerang": 
                    case "dragonbone_dagger": 
                    case "dragonbone_glaive": 
                    case "dragonbone_halberd": 
                    case "dragonbone_hammer": 
                    case "dragonbone_javelin": 
                    case "dragonbone_lance": 
                    case "dragonbone_mace": 
                    case "dragonbone_pike": 
                    case "dragonbone_quarterstaff": 
                    case "dragonbone_tomahawk": 
                    case "dragonbone_throwing_knife": 
                    case "dragonbone_warhammer": 
                    case "dragonbone_battleaxe": 
                    case "dragonbone_crossbow": {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                String specialAbility = switch (dragonBloodName) {
                    case "dragon_blood_fire" -> "flamed";
                    case "dragon_blood_ice" -> "iced";
                    case "dragon_blood_lightning" -> "lightning";
                    default -> null;
                };
                String weaponType = dragonboneWeaponName.substring(dragonboneWeaponName.indexOf("_") + 1);
                String upgradedWeaponName = "dragonbone_" + specialAbility + "_" + weaponType;
                NamespacedKey recipeKey = NamespacedKey.fromString((String)upgradedWeaponName, (Plugin)this.plugin);
                if (Bukkit.getRecipe((NamespacedKey)recipeKey) != null) {
                    RSVItem upgradedWeapon = RSVItem.getItem(upgradedWeaponName);
                    event.getInventory().setResult((ItemStack)upgradedWeapon);
                }
            }
        }
    }
}

