/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanweaponry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;

public class EntityLongAttackTask
extends BukkitRunnable {
    private final LivingEntity attacker;
    private final RSVPlugin plugin;
    private final double chance;
    private final double reach;
    private final List<String> blacklistedMobs;
    private final List<String> blacklistedItems;
    private final Entity target;
    private static final Map<UUID, EntityLongAttackTask> tasks = new HashMap<UUID, EntityLongAttackTask>();

    public EntityLongAttackTask(RSVModule module, RSVPlugin plugin, LivingEntity attacker, ItemStack item, Entity target) {
        FileConfiguration config = module.getUserConfig().getConfig();
        FileConfiguration swConfig = RSVModule.getModule("SpartanWeaponry").getUserConfig().getConfig();
        String name = RSVItem.getNameFromItem(item);
        this.plugin = plugin;
        this.attacker = attacker;
        this.chance = swConfig.getDouble("MobAbilities.UseLongReachWeapons.Chance");
        this.reach = config.getDouble("Items." + name + ".Reach");
        this.blacklistedMobs = swConfig.getStringList("MobAbilities.UseLongReachWeapons.MobBlacklist");
        this.blacklistedItems = swConfig.getStringList("MobAbilities.UseLongReachWeapons.WeaponBlacklist");
        this.target = target;
        tasks.put(attacker.getUniqueId(), this);
    }

    public void run() {
        if (this.attacker == null) {
            this.stop();
        } else if (this.blacklistedMobs.contains(this.attacker.getType().toString()) || this.attacker.getEquipment() == null || this.attacker.isDead()) {
            this.stop();
        } else {
            ItemStack itemMainHand = this.attacker.getEquipment().getItemInMainHand();
            if (this.isItemValid(itemMainHand)) {
                if (Utils.roll(this.chance)) {
                    Entity defender;
                    Location eye = this.attacker.getEyeLocation().add(this.attacker.getLocation().getDirection());
                    Predicate<Entity> filter = entity -> !entity.getUniqueId().equals(this.attacker.getUniqueId());
                    RayTraceResult result = this.attacker.getWorld().rayTrace(this.attacker.getEyeLocation(), eye.getDirection(), this.reach, FluidCollisionMode.NEVER, false, 0.0, filter);
                    if (result != null && (defender = result.getHitEntity()) != null) {
                        if (this.target == null) {
                            Utils.attack(this.attacker, defender);
                        } else if (this.target.getUniqueId().equals(defender.getUniqueId())) {
                            Utils.attack(this.attacker, this.target);
                        }
                    }
                }
            } else {
                this.stop();
            }
        }
    }

    public void start() {
        FileConfiguration swConfig = RSVModule.getModule("SpartanWeaponry").getUserConfig().getConfig();
        this.runTaskTimer((Plugin)this.plugin, 0L, swConfig.getInt("MobAbilities.UseLongReachWeapons.TickPeriod"));
    }

    public void stop() {
        tasks.remove(this.attacker.getUniqueId());
        this.cancel();
    }

    public boolean isItemValid(@Nullable ItemStack item) {
        String name;
        if (Utils.isItemReal(item) && RSVItem.isRSVItem(item) && !this.blacklistedItems.contains(name = RSVItem.getNameFromItem(item)) && name.contains("_")) {
            String type;
            switch (type = name.substring(name.lastIndexOf("_") + 1)) {
                case "greatsword": 
                case "spear": 
                case "halberd": 
                case "pike": 
                case "lance": {
                    return true;
                }
            }
        }
        return false;
    }

    public LivingEntity getAttacker() {
        return this.attacker;
    }

    public static Map<UUID, EntityLongAttackTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        if (tasks.containsKey(id)) {
            return tasks.get(id) != null;
        }
        return false;
    }
}

