/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanweaponry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanweaponry.ThrowWeaponTask;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class EntityPrepareThrowTask
extends BukkitRunnable {
    private final FileConfiguration config;
    private final LivingEntity entity;
    private final RSVPlugin plugin;
    private final RSVModule module;
    private final double chance;
    private final boolean rotateWeapon;
    private final boolean piercing;
    private final boolean returnWeaponCollideBlocks;
    private final boolean returnWeaponCollideEntities;
    private final boolean returnWeaponTooFar;
    private final double maxDistance;
    private final List<String> blacklistedMobs;
    private final List<String> blacklistedItems;
    private static final Map<UUID, EntityPrepareThrowTask> tasks = new HashMap<UUID, EntityPrepareThrowTask>();

    public EntityPrepareThrowTask(RSVModule module, RSVPlugin plugin, LivingEntity entity, ItemStack item) {
        this.module = module;
        this.config = module.getUserConfig().getConfig();
        FileConfiguration swConfig = RSVModule.getModule("SpartanWeaponry").getUserConfig().getConfig();
        String name = RSVItem.getNameFromItem(item);
        this.plugin = plugin;
        this.entity = entity;
        this.chance = swConfig.getDouble("MobAbilities.UseThrowingWeapons.Chance");
        this.rotateWeapon = this.config.getBoolean("Items." + name + ".ThrownAttributes.Rotate");
        this.piercing = this.config.getBoolean("Items." + name + ".ThrownAttributes.Piercing");
        this.returnWeaponCollideBlocks = this.config.getBoolean("Items." + name + ".ThrownAttributes.ReturnAfterHittingBlock");
        this.returnWeaponCollideEntities = this.config.getBoolean("Items." + name + ".ThrownAttributes.ReturnAfterHittingEntity");
        this.returnWeaponTooFar = this.config.getBoolean("Items." + name + ".ThrownAttributes.ReturnAfterTravelingMaxDistance");
        this.maxDistance = this.config.getDouble("Items." + name + ".ThrownAttributes.MaxDistance");
        this.blacklistedMobs = swConfig.getStringList("MobAbilities.UseThrowingWeapons.MobBlacklist");
        this.blacklistedItems = swConfig.getStringList("MobAbilities.UseThrowingWeapons.WeaponBlacklist");
        tasks.put(entity.getUniqueId(), this);
    }

    public void run() {
        if (this.entity == null) {
            this.stop();
        } else if (this.blacklistedMobs.contains(this.entity.getType().toString()) || this.entity.isDead() || this.entity.getEquipment() == null) {
            this.stop();
        } else {
            ItemStack itemMainHand = this.entity.getEquipment().getItemInMainHand();
            if (this.isItemValid(itemMainHand)) {
                if (Utils.roll(this.chance)) {
                    String name = RSVItem.getNameFromItem(itemMainHand);
                    Location loc = this.entity.getLocation();
                    Vector velocity = loc.getDirection().normalize().multiply(this.config.getDouble("Items." + name + ".ThrownAttributes.Velocity"));
                    if (!ThrowWeaponTask.hasTask(this.entity.getUniqueId())) {
                        new ThrowWeaponTask(this.module, this.plugin, this.entity, itemMainHand, this.maxDistance, this.rotateWeapon, this.piercing, this.returnWeaponCollideBlocks, this.returnWeaponCollideEntities, this.returnWeaponTooFar, velocity).start();
                        this.entity.getEquipment().setItemInMainHand(null);
                    }
                }
            } else {
                this.stop();
            }
        }
    }

    public void stop() {
        tasks.remove(this.entity.getUniqueId());
        this.cancel();
    }

    public void start() {
        FileConfiguration swConfig = RSVModule.getModule("SpartanWeaponry").getUserConfig().getConfig();
        this.runTaskTimer((Plugin)this.plugin, 0L, swConfig.getInt("MobAbilities.UseThrowingWeapons.TickPeriod"));
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public boolean isItemValid(@Nullable ItemStack item) {
        String name;
        if (Utils.isItemReal(item) && RSVItem.isRSVItem(item) && !this.blacklistedItems.contains(name = RSVItem.getNameFromItem(item)) && name.contains("_")) {
            String type;
            switch (type = name.substring(name.lastIndexOf("_") + 1)) {
                case "dagger": 
                case "tomahawk": 
                case "javelin": 
                case "boomerang": 
                case "throwing_knife": {
                    return true;
                }
            }
            return name.endsWith("throwing_knife");
        }
        return false;
    }

    public static Map<UUID, EntityPrepareThrowTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        if (tasks.containsKey(id)) {
            return tasks.get(id) != null;
        }
        return false;
    }
}

