/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanweaponry;

import java.util.Map;
import me.val_mobile.data.RSVModule;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ReturnWeaponTask
extends BukkitRunnable {
    private final double maxReturnDistance;
    private final String name;
    private final FileConfiguration config;
    private final ItemStack item;
    private final ArmorStand armorStand;
    private final LivingEntity entity;
    private final boolean rotateWeapon;

    public ReturnWeaponTask(RSVModule module, ItemStack item, ArmorStand armorStand, LivingEntity entity, boolean rotateWeapon) {
        this.item = item;
        this.armorStand = armorStand;
        this.entity = entity;
        this.config = module.getUserConfig().getConfig();
        this.name = RSVItem.getNameFromItem(item);
        this.maxReturnDistance = this.config.getDouble("Items." + this.name + ".ThrownAttributes.MaxReturnDistance");
        this.rotateWeapon = rotateWeapon;
    }

    public void run() {
        Location asLocation = this.armorStand.getLocation();
        Vector asVector = asLocation.toVector();
        if (this.entity == null) {
            this.dropItem(asLocation);
            this.stop();
        } else {
            Player player;
            LivingEntity livingEntity = this.entity;
            if (livingEntity instanceof Player && !(player = (Player)livingEntity).isOnline()) {
                this.dropItem(asLocation);
                this.stop();
            } else {
                Location pLocation = this.entity.getLocation();
                Vector pVector = pLocation.toVector();
                this.armorStand.teleport(asLocation.subtract(asVector.subtract(pVector).normalize()).setDirection(pLocation.getDirection()));
                if (this.rotateWeapon) {
                    this.armorStand.setRightArmPose(Utils.setRightArmAngle(this.armorStand, 45, 0, 0));
                }
                if (asLocation.getWorld().getName().equals(pLocation.getWorld().getName())) {
                    String message;
                    if (this.distanceBetween(asLocation, pLocation) > this.maxReturnDistance) {
                        Location dropLoc = this.dropItem(asLocation);
                        if (this.config.getBoolean("MaxReturnDistanceReached.Enabled")) {
                            message = Utils.translateMsg(this.config.getString("MaxReturnDistanceReached.Message"), (CommandSender)this.entity, Map.of("MAX_DISTANCE", Math.round(this.maxReturnDistance)));
                            this.entity.sendMessage(message);
                        }
                        if (this.config.getBoolean("WeaponDropped.Enabled")) {
                            message = Utils.translateMsg(this.config.getString("WeaponDropped.Message"), (CommandSender)this.entity, Map.of("X_COORD", (int)Math.round(dropLoc.getX()), "Y_COORD", (int)Math.round(dropLoc.getY()), "Z_COORD", (int)Math.round(dropLoc.getZ())));
                            this.entity.sendMessage(message);
                        }
                        this.stop();
                    }
                    if (this.distanceBetween(asLocation, pLocation) < 0.5) {
                        Player player2;
                        LivingEntity livingEntity2 = this.entity;
                        boolean isInvFull = livingEntity2 instanceof Player ? (player2 = (Player)livingEntity2).getInventory().firstEmpty() == -1 : (this.entity.getEquipment() == null ? true : Utils.isItemReal(this.entity.getEquipment().getItemInMainHand()));
                        if (this.config.getBoolean("Items." + this.name + ".ThrownAttributes.ReturnSound.Enabled")) {
                            String soundName = this.config.getString("Items." + this.name + ".ThrownAttributes.ReturnSound.Sound");
                            float volume = (float)this.config.getDouble("Items." + this.name + ".ThrownAttributes.ReturnSound.Volume");
                            float pitch = (float)this.config.getDouble("Items." + this.name + ".ThrownAttributes.ReturnSound.Pitch");
                            Utils.playSound(this.entity.getLocation(), soundName, volume, pitch);
                        }
                        this.stop();
                        if (isInvFull) {
                            if (this.config.getBoolean("FullInventoryWeaponDropped.Enabled")) {
                                message = Utils.translateMsg(this.config.getString("FullInventoryWeaponDropped.Message"), (CommandSender)this.entity, Map.of("X_COORD", (int)Math.round(pLocation.getX()), "Y_COORD", (int)Math.round(pLocation.getY()), "Z_COORD", (int)Math.round(pLocation.getZ())));
                                this.entity.sendMessage(message);
                            }
                            this.dropItem(pLocation);
                        } else {
                            livingEntity2 = this.entity;
                            if (livingEntity2 instanceof Player) {
                                player2 = (Player)livingEntity2;
                                player2.getInventory().addItem(new ItemStack[]{this.item.clone()});
                            } else {
                                this.entity.getEquipment().setItemInMainHand(this.item.clone());
                            }
                        }
                        this.stop();
                    }
                } else {
                    this.dropItem(asLocation);
                    this.stop();
                }
            }
        }
    }

    public Location dropItem(Location location) {
        Item droppedItem = this.entity.getWorld().dropItem(location, this.item.clone());
        droppedItem.setGlowing(true);
        droppedItem.setOwner(this.entity.getUniqueId());
        return droppedItem.getLocation();
    }

    public double distanceBetween(Location asLoc, Location pLoc) {
        return asLoc.distance(pLoc);
    }

    public void stop() {
        this.armorStand.remove();
        this.cancel();
    }
}

