/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanweaponry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import me.val_mobile.rsv.RSVPlugin;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SweepAttackTask
extends BukkitRunnable {
    private static final Collection<UUID> mobs = new ArrayList<UUID>();
    private final RSVPlugin plugin;
    private final List<Entity> nearby;
    private final List<UUID> attacked = new ArrayList<UUID>();
    private final Entity attacker;
    private final Entity defender;
    private final double damage;
    private final boolean checkPet;

    public SweepAttackTask(RSVPlugin plugin, List<Entity> nearby, Entity attacker, Entity defender, double damage, boolean checkPet) {
        this.plugin = plugin;
        this.attacker = attacker;
        this.defender = defender;
        this.damage = damage;
        this.nearby = nearby;
        this.checkPet = checkPet;
    }

    public void run() {
        Location defLoc = this.defender.getLocation();
        for (Entity e : this.nearby) {
            UUID id;
            Location eLoc;
            LivingEntity living;
            if (e.getUniqueId().equals(this.attacker.getUniqueId()) || e.getUniqueId().equals(this.defender.getUniqueId()) || !(e instanceof LivingEntity) || this.isPet(living = (LivingEntity)e) && this.checkPet || !(Math.abs((eLoc = living.getLocation()).getY() - defLoc.getY()) <= 0.25) || !(Math.hypot(eLoc.getX() - defLoc.getX(), eLoc.getZ() - defLoc.getZ()) <= 1.0) || mobs.contains(id = living.getUniqueId())) continue;
            living.damage(this.damage, this.attacker);
            mobs.add(id);
            this.attacked.add(id);
        }
        this.removeImmunity();
    }

    private boolean isPet(LivingEntity entity) {
        Tameable tameable;
        Player owner;
        if (entity instanceof Tameable && (owner = (Player)(tameable = (Tameable)entity).getOwner()) != null) {
            return owner.getUniqueId().equals(this.attacker.getUniqueId());
        }
        return false;
    }

    public void start() {
        this.runTask((Plugin)this.plugin);
    }

    private void removeImmunity() {
        new BukkitRunnable(){

            public void run() {
                for (UUID id : SweepAttackTask.this.attacked) {
                    mobs.remove(id);
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }
}

