/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanweaponry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.spartanandfire.BurnTask;
import me.val_mobile.spartanandfire.ElectrocuteTask;
import me.val_mobile.spartanandfire.FreezeTask;
import me.val_mobile.spartanweaponry.ReturnWeaponTask;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class ThrowWeaponTask
extends BukkitRunnable {
    private final double maxDistanceSquared;
    private final FileConfiguration config;
    private final String name;
    private final ArmorStand armorStand;
    private final LivingEntity entity;
    private final ItemStack item;
    private final boolean rotateWeapon;
    private final boolean piercing;
    private final boolean returnWeaponCollideBlocks;
    private final boolean returnWeaponCollideEntities;
    private final boolean returnWeaponTooFar;
    private final RSVModule module;
    private final RSVPlugin plugin;
    private final Location started;
    private final Vector vector;
    private static final Map<UUID, ThrowWeaponTask> tasks = new HashMap<UUID, ThrowWeaponTask>();

    public ThrowWeaponTask(RSVModule module, RSVPlugin plugin, LivingEntity entity, ItemStack item, double maxDistance, boolean rotateWeapon, boolean piercing, boolean returnWeaponCollideBlocks, boolean returnWeaponCollideEntities, boolean returnWeaponTooFar, Vector velocity) {
        this.config = module.getUserConfig().getConfig();
        this.module = module;
        this.name = RSVItem.getNameFromItem(item);
        this.maxDistanceSquared = maxDistance * maxDistance;
        this.plugin = plugin;
        this.entity = entity;
        this.item = item;
        this.rotateWeapon = rotateWeapon;
        this.piercing = piercing;
        this.returnWeaponCollideBlocks = returnWeaponCollideBlocks;
        this.returnWeaponCollideEntities = returnWeaponCollideEntities;
        this.returnWeaponTooFar = returnWeaponTooFar;
        this.vector = velocity.multiply(0.05);
        this.started = entity.getLocation().add(0.0, 0.9, 0.0);
        this.armorStand = this.spawnArmorstand(entity, item);
        tasks.put(entity.getUniqueId(), this);
    }

    public ArmorStand spawnArmorstand(LivingEntity thrower, ItemStack itemStack) {
        return (ArmorStand)thrower.getWorld().spawn(this.started.clone(), ArmorStand.class, armorStand -> {
            armorStand.setArms(true);
            armorStand.setGravity(false);
            armorStand.setVisible(false);
            armorStand.setSmall(true);
            armorStand.setMarker(true);
            armorStand.setCustomNameVisible(false);
            armorStand.setPersistent(false);
            if (this.config.getBoolean("Items." + this.name + ".ThrownAttributes.ThrownSound.Enabled")) {
                String soundName = this.config.getString("Items." + this.name + ".ThrownAttributes.ThrownSound.Sound");
                float volume = (float)this.config.getDouble("Items." + this.name + ".ThrownAttributes.ThrownSound.Volume");
                float pitch = (float)this.config.getDouble("Items." + this.name + ".ThrownAttributes.ThrownSound.Pitch");
                Utils.playSound(thrower.getLocation(), soundName, volume, pitch);
            }
            armorStand.setRightArmPose(Utils.setRightArmAngle(armorStand, 270, 0, 0));
            Objects.requireNonNull(armorStand.getEquipment()).setItemInMainHand(itemStack.clone());
        });
    }

    public void run() {
        if (this.entity == null) {
            this.dropWeaponTask(this.armorStand, this.item);
        } else {
            Player player;
            LivingEntity livingEntity = this.entity;
            if (livingEntity instanceof Player && !(player = (Player)livingEntity).isOnline()) {
                this.dropWeaponTask(this.armorStand, this.item);
            } else if (this.entity.getEquipment() != null) {
                Location loc = this.armorStand.getLocation().add(this.vector);
                this.armorStand.teleport(loc);
                if (this.rotateWeapon) {
                    this.armorStand.setRightArmPose(Utils.setRightArmAngle(this.armorStand, 45, 0, 0));
                }
                RayTraceResult result = this.armorStand.rayTraceBlocks(0.109);
                List entityList = this.armorStand.getNearbyEntities(0.3, 0.3, 0.3);
                if (result != null && result.getHitBlock() != null && !result.getHitBlock().isPassable()) {
                    if (this.returnWeaponCollideBlocks) {
                        this.returnWeapon();
                    } else {
                        this.dropWeaponTask(this.armorStand, this.entity, this.item.clone());
                    }
                    if (this.config.getBoolean("Items." + this.name + ".ThrownAttributes.HitGroundSound.Enabled")) {
                        String soundName = this.config.getString("Items." + this.name + ".ThrownAttributes.HitGroundSound.Sound");
                        float volume = (float)this.config.getDouble("Items." + this.name + ".ThrownAttributes.HitGroundSound.Volume");
                        float pitch = (float)this.config.getDouble("Items." + this.name + ".ThrownAttributes.HitGroundSound.Pitch");
                        Utils.playSound(this.armorStand.getLocation(), soundName, volume, pitch);
                    }
                }
                if (!entityList.isEmpty() && !entityList.contains(this.entity)) {
                    if (this.onlyContainsEndermen(entityList)) {
                        for (Entity e : entityList) {
                            if (!(e instanceof Enderman)) continue;
                            Enderman enderman = (Enderman)e;
                            Utils.randomTpSafely((Entity)enderman, 16.0);
                        }
                    } else {
                        double attackDamage = this.config.getDouble("Items." + this.name + ".ThrownAttributes.AttackDamage");
                        for (Entity e : entityList) {
                            if (!(e instanceof Damageable)) continue;
                            Damageable damageable = (Damageable)e;
                            if (e.getUniqueId() == this.entity.getUniqueId()) continue;
                            if (e instanceof Enderman) {
                                Enderman enderman = (Enderman)e;
                                Utils.randomTpSafely((Entity)enderman, 16.0);
                                continue;
                            }
                            String name = RSVItem.getNameFromItem(this.item);
                            String type = name.substring(0, name.lastIndexOf("_"));
                            boolean shouldBurn = false;
                            boolean shouldFreeze = false;
                            boolean shouldStrikeLightning = false;
                            boolean shouldElectrocute = false;
                            switch (type) {
                                case "dragonbone_flamed": {
                                    if (Utils.hasNbtTag((Entity)damageable, "rsvmob") && !((String)Utils.getNbtTag((Entity)damageable, "rsvmob", PersistentDataType.STRING)).equals("fire_dragon")) {
                                        attackDamage += this.config.getDouble("Items." + name + ".DragonBonusDamage");
                                    }
                                    if (BurnTask.hasTask(damageable.getUniqueId())) break;
                                    shouldBurn = true;
                                    break;
                                }
                                case "dragonbone_iced": {
                                    if (Utils.hasNbtTag((Entity)damageable, "rsvmob") && !((String)Utils.getNbtTag((Entity)damageable, "rsvmob", PersistentDataType.STRING)).equals("ice_dragon")) {
                                        attackDamage += this.config.getDouble("Items." + name + ".DragonBonusDamage");
                                    }
                                    if (FreezeTask.hasTask(damageable.getUniqueId())) break;
                                    shouldFreeze = true;
                                    break;
                                }
                                case "dragonbone_lightning": {
                                    if (Utils.hasNbtTag((Entity)damageable, "rsvmob") && !((String)Utils.getNbtTag((Entity)damageable, "rsvmob", PersistentDataType.STRING)).equals("lightning_dragon")) {
                                        attackDamage += this.config.getDouble("Items." + name + ".DragonBonusDamage");
                                    }
                                    shouldStrikeLightning = true;
                                    if (ElectrocuteTask.hasTask(damageable.getUniqueId())) break;
                                    shouldElectrocute = true;
                                    break;
                                }
                                case "dragonsteel_fire": {
                                    if (BurnTask.hasTask(damageable.getUniqueId())) break;
                                    shouldBurn = true;
                                    break;
                                }
                                case "dragonsteel_ice": {
                                    if (FreezeTask.hasTask(damageable.getUniqueId())) break;
                                    shouldFreeze = true;
                                    break;
                                }
                                case "dragonsteel_lightning": {
                                    shouldStrikeLightning = true;
                                    if (ElectrocuteTask.hasTask(damageable.getUniqueId())) break;
                                    shouldElectrocute = true;
                                    break;
                                }
                            }
                            if (name.contains("dagger") && Utils.wasBackstabbed((Entity)this.entity, (Entity)damageable)) {
                                attackDamage *= this.config.getDouble("Items." + name + ".BackstabDamageMultiplier");
                            }
                            if (!this.isAttackable(damageable)) continue;
                            if (shouldBurn) {
                                int fireTicks = this.config.getInt("Items." + name + ".InfernoAbility.FireTicks");
                                int tickPeriod = this.config.getInt("Items." + name + ".InfernoAbility.TickPeriod");
                                new BurnTask(this.plugin, (Entity)damageable, fireTicks, tickPeriod).start();
                            }
                            if (shouldFreeze) {
                                new FreezeTask(this.plugin, this.module, name, (Entity)damageable).start();
                            }
                            if (shouldStrikeLightning && this.config.getBoolean("Items." + name + ".ElectrocuteAbility.SummonLightning.Enabled")) {
                                Location eLoc = damageable.getLocation();
                                if (this.config.getBoolean("Items." + name + ".ElectrocuteAbility.SummonLightning.Cosmetic")) {
                                    eLoc.getWorld().strikeLightningEffect(loc);
                                } else {
                                    eLoc.getWorld().strikeLightning(loc);
                                }
                            }
                            if (shouldElectrocute) {
                                new ElectrocuteTask(this.plugin, this.module, name, damageable).start();
                            }
                            Utils.damageEntity(damageable, attackDamage, (Entity)this.entity);
                        }
                        if (this.config.getBoolean("Items." + this.name + ".ThrownAttributes.HitMobSound.Enabled")) {
                            String soundName = this.config.getString("Items." + this.name + ".ThrownAttributes.HitMobSound.Sound");
                            float volume = (float)this.config.getDouble("Items." + this.name + ".ThrownAttributes.HitMobSound.Volume");
                            float pitch = (float)this.config.getDouble("Items." + this.name + ".ThrownAttributes.HitMobSound.Pitch");
                            Utils.playSound(this.armorStand.getLocation(), soundName, volume, pitch);
                        }
                        if (this.returnWeaponCollideEntities && !this.piercing) {
                            this.returnWeapon();
                        }
                        if (!this.piercing) {
                            this.dropWeaponTask(this.armorStand, this.entity, this.item.clone());
                        }
                    }
                }
                if (this.armorStand.getWorld().getName().equals(this.entity.getWorld().getName())) {
                    if (this.armorStand.getLocation().distanceSquared(this.started) > this.maxDistanceSquared) {
                        if (this.returnWeaponTooFar) {
                            this.returnWeapon();
                        } else {
                            if (this.config.getBoolean("MaxDistanceReached.Enabled")) {
                                String message = Utils.translateMsg(this.config.getString("MaxDistanceReached.Message"), (CommandSender)this.entity, Map.of("MAX_DISTANCE", Math.round(Math.sqrt(this.maxDistanceSquared))));
                                this.entity.sendMessage(message);
                            }
                            this.dropWeaponTask(this.armorStand, this.entity, this.item.clone());
                        }
                    }
                } else {
                    this.dropWeaponTask(this.armorStand, this.entity, this.item.clone());
                }
            } else {
                this.dropWeaponTask(this.armorStand, this.item);
            }
        }
    }

    public boolean onlyContainsEndermen(@Nullable List<Entity> entities) {
        if (entities == null) {
            return false;
        }
        for (Entity e : entities) {
            if (e instanceof Enderman) continue;
            return false;
        }
        return true;
    }

    public void dropWeaponTask(ArmorStand as, ItemStack itemStack) {
        Item droppedItem = as.getWorld().dropItem(as.getLocation(), itemStack.clone());
        droppedItem.setGlowing(true);
        as.remove();
        tasks.remove(this.entity.getUniqueId());
        this.cancel();
    }

    public void dropWeaponTask(ArmorStand as, LivingEntity entity, ItemStack itemStack) {
        Item droppedItem = as.getWorld().dropItem(as.getLocation(), itemStack.clone());
        Location loc = droppedItem.getLocation();
        droppedItem.setGlowing(true);
        as.remove();
        if (this.config.getBoolean("WeaponDropped.Enabled")) {
            String message = Utils.translateMsg(this.config.getString("WeaponDropped.Message"), (CommandSender)this.entity, Map.of("X_COORD", (int)Math.round(loc.getX()), "Y_COORD", (int)Math.round(loc.getY()), "Z_COORD", (int)Math.round(loc.getZ())));
            entity.sendMessage(message);
        }
        tasks.remove(entity.getUniqueId());
        this.cancel();
    }

    public void returnWeapon() {
        new ReturnWeaponTask(this.module, this.item, this.armorStand, this.entity, this.rotateWeapon).runTaskTimer((Plugin)this.plugin, 4L, 1L);
        this.cancel();
        tasks.remove(this.entity.getUniqueId());
    }

    public void start() {
        this.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void centeredThrow() {
        this.armorStand.teleport(this.entity.getLocation().add(0.0, 0.9, 0.0));
    }

    public void resetArmorstandArmPos() {
        this.armorStand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public static Map<UUID, ThrowWeaponTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public boolean isAttackable(Damageable damageable) {
        if (damageable instanceof Player) {
            Player p = (Player)damageable;
            return !p.isBlocking() || Utils.wasBackstabbed((Entity)this.entity, (Entity)p);
        }
        return true;
    }
}

