/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.spartanweaponry;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class TwoHandedTask
extends BukkitRunnable {
    private static final Map<UUID, TwoHandedTask> tasks = new HashMap<UUID, TwoHandedTask>();
    private final FileConfiguration config;
    private final RSVPlugin plugin;
    private final UUID id;
    private final String itemName;

    public TwoHandedTask(RSVModule module, RSVPlugin plugin, LivingEntity entity, String itemName) {
        this.plugin = plugin;
        this.config = module.getUserConfig().getConfig();
        this.id = entity.getUniqueId();
        this.itemName = itemName;
        tasks.put(this.id, this);
    }

    public void run() {
        Entity entity = Bukkit.getEntity((UUID)this.id);
        if (entity == null) {
            tasks.remove(this.id);
            this.cancel();
        } else if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.getEquipment() != null) {
                ItemStack itemMainhand = living.getEquipment().getItemInMainHand();
                if (RSVItem.isRSVItem(itemMainhand) && Utils.isItemReal(living.getEquipment().getItemInOffHand())) {
                    String type;
                    FileConfiguration config = RSVModule.getModule(RSVItem.getModuleNameFromItem(itemMainhand)).getUserConfig().getConfig();
                    String name = RSVItem.getNameFromItem(itemMainhand);
                    switch (type = name.substring(name.lastIndexOf("_") + 1)) {
                        case "longsword": 
                        case "katana": 
                        case "greatsword": 
                        case "warhammer": 
                        case "halberd": 
                        case "pike": 
                        case "battleaxe": 
                        case "glaive": {
                            living.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, config.getInt("Items." + name + ".MiningFatigue.Duration"), config.getInt("Items." + name + ".MiningFatigue.Amplifier")));
                            break;
                        }
                        default: {
                            tasks.remove(this.id);
                            this.cancel();
                            break;
                        }
                    }
                } else {
                    tasks.remove(this.id);
                    this.cancel();
                }
            } else {
                tasks.remove(this.id);
                this.cancel();
            }
        } else {
            tasks.remove(this.id);
            this.cancel();
        }
    }

    public void start() {
        int tickPeriod = this.config.getInt("Items." + this.itemName + ".MiningFatigue.TickPeriod");
        this.runTaskTimer((Plugin)this.plugin, 1L, tickPeriod);
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }

    public static Map<UUID, TwoHandedTask> getTasks() {
        return tasks;
    }
}

