/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVPlayer;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanModule;
import me.val_mobile.tan.ThirstCalculateTask;
import me.val_mobile.utils.DisplayTask;
import me.val_mobile.utils.RSVTask;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class ParasiteTask
extends BukkitRunnable
implements RSVTask {
    private final TanModule module;
    private final FileConfiguration config;
    private final RSVPlugin plugin;
    private static final Map<UUID, ParasiteTask> tasks = new HashMap<UUID, ParasiteTask>();
    private final RSVPlayer player;
    private final Collection<String> allowedWorlds;
    private final boolean damageEnabled;
    private final double damage;
    private final double damageCutoff;
    private final UUID id;
    private final int duration;
    private final int tickPeriod;
    private final Collection<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
    private final boolean potionEffectsEnabled;
    private int ticks = 0;

    public ParasiteTask(TanModule module, RSVPlugin plugin, RSVPlayer player) {
        this.plugin = plugin;
        this.module = module;
        this.config = module.getUserConfig().getConfig();
        this.player = player;
        this.id = player.getPlayer().getUniqueId();
        this.allowedWorlds = module.getAllowedWorlds();
        this.damageEnabled = this.config.getBoolean("Thirst.Parasites.Damage.Enabled");
        this.damage = this.config.getDouble("Thirst.Parasites.Damage.Amount");
        this.damageCutoff = this.config.getDouble("Thirst.Parasites.Damage.Cutoff");
        this.duration = this.config.getInt("Thirst.Parasites.Duration");
        this.tickPeriod = this.config.getInt("Thirst.Parasites.TickPeriod");
        this.potionEffectsEnabled = this.config.getBoolean("Thirst.Parasites.PotionEffects.Enabled");
        ConfigurationSection section = this.config.getConfigurationSection("Thirst.Parasites.PotionEffects.Effects");
        Set keys = section.getKeys(false);
        for (String key : keys) {
            int dur = section.getInt(key + ".Duration");
            int amp = section.getInt(key + ".Amplifier");
            this.potionEffects.add(new PotionEffect(PotionEffectType.getByName((String)key), dur, amp));
        }
        tasks.put(this.id, this);
    }

    public void run() {
        Player player = this.player.getPlayer();
        if (this.conditionsMet(player)) {
            this.ticks += this.tickPeriod;
            DisplayTask.getTasks().get(this.id).setParasitesActive(true);
            if (!player.hasPermission("realisticsurvival.toughasnails.resistance.parasite.damage") && this.damageEnabled && player.getHealth() >= this.damageCutoff) {
                if (player.getHealth() - this.damage <= 0.0) {
                    this.module.getParasiteDeath().add(this.id);
                }
                player.damage(this.damage);
            }
        } else {
            this.stop();
        }
    }

    @Override
    public boolean conditionsMet(@Nullable Player player) {
        return this.globalConditionsMet((LivingEntity)player) && !player.isDead() && this.allowedWorlds.contains(player.getWorld().getName()) && this.ticks < this.duration;
    }

    @Override
    public void start() {
        Player player = this.player.getPlayer();
        ThirstCalculateTask.getTasks().get(this.id).setParasitesActive(true);
        if (!player.hasPermission("realisticsurvival.toughasnails.resistance.parasite.potioneffects") && this.potionEffectsEnabled) {
            player.addPotionEffects(this.potionEffects);
        }
        this.runTaskTimer((Plugin)this.plugin, 0L, this.tickPeriod);
    }

    @Override
    public void stop() {
        if (ThirstCalculateTask.hasTask(this.id)) {
            ThirstCalculateTask.getTasks().get(this.id).setParasitesActive(false);
        }
        if (DisplayTask.hasTask(this.id)) {
            DisplayTask.getTasks().get(this.id).setParasitesActive(false);
        }
        tasks.remove(this.id);
        this.cancel();
    }

    public static Map<UUID, ParasiteTask> getTasks() {
        return tasks;
    }

    public static boolean hasTask(UUID id) {
        return tasks.containsKey(id) && tasks.get(id) != null;
    }
}

