/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.tan;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.val_mobile.data.ModuleItems;
import me.val_mobile.data.ModuleRecipes;
import me.val_mobile.data.RSVConfig;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.tan.TanEvents;
import me.val_mobile.tan.TempManager;
import me.val_mobile.tan.ThirstManager;
import me.val_mobile.utils.Utils;
import org.bukkit.configuration.file.FileConfiguration;

public class TanModule
extends RSVModule {
    private final RSVPlugin plugin;
    private final RSVConfig config;
    private TanEvents events;
    public static final String NAME = "ToughAsNails";
    private final Set<UUID> hypothermiaDeath = new HashSet<UUID>();
    private final Set<UUID> hyperthermiaDeath = new HashSet<UUID>();
    private final Set<UUID> dehydrationDeath = new HashSet<UUID>();
    private final Set<UUID> parasiteDeath = new HashSet<UUID>();
    private final TempManager tempManager;
    private ThirstManager thirstManager;
    private boolean tempGloballyEnabled;
    private boolean thirstGloballyEnabled;

    public TanModule(RSVPlugin plugin) {
        super(NAME, plugin, Map.of(), Map.of());
        this.plugin = plugin;
        this.config = new RSVConfig(plugin, "resources/toughasnails/playerdata.yml");
        this.tempManager = new TempManager(this);
    }

    @Override
    public void initialize() {
        this.setUserConfig(new RSVConfig(this.plugin, "toughasnails.yml"));
        this.setItemConfig(new RSVConfig(this.plugin, "resources/toughasnails/items.yml"));
        this.setRecipeConfig(new RSVConfig(this.plugin, "resources/toughasnails/recipes.yml"));
        this.thirstManager = new ThirstManager(this);
        this.setModuleItems(new ModuleItems(this));
        this.setModuleRecipes(new ModuleRecipes(this, this.plugin));
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Initialize.Enabled")) {
            String message = Utils.translateMsg(config.getString("Initialize.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
        this.tempGloballyEnabled = config.getBoolean("Temperature.Enabled") && this.isGloballyEnabled();
        this.thirstGloballyEnabled = config.getBoolean("Thirst.Enabled") && this.isGloballyEnabled();
        this.events = new TanEvents(this, this.plugin);
        this.getModuleItems().initialize();
        this.getModuleRecipes().initialize();
        this.events.initialize();
    }

    @Override
    public void shutdown() {
        FileConfiguration config = this.getUserConfig().getConfig();
        if (config.getBoolean("Shutdown.Enabled")) {
            String message = Utils.translateMsg(config.getString("Shutdown.Message"), null, Map.of("NAME", NAME));
            this.plugin.getLogger().info(message);
        }
    }

    @Nonnull
    public TempManager getTempManager() {
        return this.tempManager;
    }

    @Nonnull
    public ThirstManager getThirstManager() {
        return this.thirstManager;
    }

    @Nonnull
    public RSVConfig getPlayerDataConfig() {
        return this.config;
    }

    @Nonnull
    public TanEvents getEvents() {
        return this.events;
    }

    @Nonnull
    public Set<UUID> getDehydrationDeath() {
        return this.dehydrationDeath;
    }

    @Nonnull
    public Set<UUID> getHyperthermiaDeath() {
        return this.hyperthermiaDeath;
    }

    @Nonnull
    public Set<UUID> getHypothermiaDeath() {
        return this.hypothermiaDeath;
    }

    @Nonnull
    public Set<UUID> getParasiteDeath() {
        return this.parasiteDeath;
    }

    public boolean isTempGloballyEnabled() {
        return this.tempGloballyEnabled;
    }

    public boolean isThirstGloballyEnabled() {
        return this.thirstGloballyEnabled;
    }
}

