/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.EnchantmentWrapper;
import me.val_mobile.utils.Utils;
import org.bukkit.enchantments.Enchantment;

public class RSVEnchants {
    private static final HashSet<Enchantment> enchants = new HashSet();
    public static final Enchantment WARMING = new EnchantmentWrapper("warming", "Warming", 1);
    public static final Enchantment COOLING = new EnchantmentWrapper("cooling", "Cooling", 1);
    public static final Enchantment OZZY_LINER = new EnchantmentWrapper("ozzy_liner", "Ozzy Liner", 1);
    private final RSVPlugin plugin;

    public RSVEnchants(RSVPlugin plugin) {
        this.plugin = plugin;
        this.populateEnchants();
    }

    public void registerAllEnchants() {
        for (Enchantment enchant : enchants) {
            this.register(enchant);
        }
    }

    public void register(Enchantment ench) {
        boolean registered = Arrays.stream(Enchantment.values()).collect(Collectors.toList()).contains(ench);
        if (!registered) {
            this.registerEnchantment(ench);
        }
    }

    public void registerEnchantment(Enchantment ench) {
        boolean registered = true;
        try {
            Field f = Enchantment.class.getDeclaredField("acceptingNew");
            f.setAccessible(true);
            f.set(null, true);
            Enchantment.registerEnchantment((Enchantment)ench);
        }
        catch (Exception e) {
            registered = false;
            e.printStackTrace();
        }
        if (registered) {
            String raw = this.plugin.getConfig().getString("RegisteredEnchant");
            this.plugin.getLogger().info(Utils.translateMsg(raw, null, Map.of("ENCHANT", ench.getKey().getKey())));
        }
    }

    public void populateEnchants() {
        enchants.add(WARMING);
        enchants.add(COOLING);
        enchants.add(OZZY_LINER);
    }

    public static HashSet<Enchantment> getEnchants() {
        return enchants;
    }
}

