/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Ingredient;
import me.val_mobile.utils.LorePresets;
import me.val_mobile.utils.Utils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class RSVItem
extends ItemStack {
    private static final Map<String, RSVItem> itemMap = new HashMap<String, RSVItem>();
    private static final String MODEL_CONFIG_DEFAULT_OPTION = "DEFAULT";
    private final Ingredient repairIng;
    private final String name;
    private final String module;
    private final FileConfiguration itemConfig;

    public RSVItem(Material material) {
        super(material);
        this.itemConfig = null;
        this.name = material.name();
        this.module = null;
        this.repairIng = new Ingredient("");
    }

    public RSVItem(RSVItem copy) {
        this(RSVModule.getModule(copy.module), copy.itemConfig, copy.name);
    }

    public RSVItem(@Nullable RSVModule module, @Nonnull FileConfiguration itemConfig, @Nonnull String name) {
        super(Material.valueOf((String)itemConfig.getString(name + ".Material")));
        Object key;
        Object s2;
        this.itemConfig = itemConfig;
        this.name = name;
        this.module = module == null ? null : module.getName();
        String materialPath = name + ".Material";
        String displayNamePath = name + ".DisplayName";
        String customModelDataPath = name + ".CustomModelData";
        String itemModelPath = name + ".ItemModel";
        String equippableComponentModelPath = name + ".EquippableComponentModel";
        String lorePath = name + ".Lore";
        String itemFlagsPath = name + ".ItemFlags";
        String enchantmentsPath = name + ".Enchantments";
        String attributesPath = name + ".Attributes";
        String nbtTagsPath = name + ".NBTTags";
        String repairIngPath = name + ".RepairIngredients";
        Material material = Material.valueOf((String)itemConfig.getString(materialPath));
        String displayName = itemConfig.getString(displayNamePath);
        int customModelData = itemConfig.getInt(customModelDataPath);
        RSVPlugin pluginNamespace = RSVPlugin.getPlugin();
        String itemModelStr = itemConfig.getString(itemModelPath);
        NamespacedKey itemModelKey = null;
        if (itemModelStr != null) {
            itemModelKey = itemModelStr.equals(MODEL_CONFIG_DEFAULT_OPTION) ? NamespacedKey.fromString((String)(module.getName().toLowerCase() + "/" + name), (Plugin)pluginNamespace) : NamespacedKey.fromString((String)itemModelStr, (Plugin)pluginNamespace);
        }
        String ecmStr = itemConfig.getString(equippableComponentModelPath);
        NamespacedKey ecmKey = null;
        if (ecmStr != null) {
            if (ecmStr.equals(MODEL_CONFIG_DEFAULT_OPTION)) {
                List<String> armorSlots = List.of("helmet", "chestplate", "leggings", "boots", "hood", "jacket", "pants");
                String armorMaterial = name;
                for (String armorSlot : armorSlots) {
                    if (!armorMaterial.contains("_" + armorSlot)) continue;
                    armorMaterial = armorMaterial.replaceAll("_" + armorSlot, "");
                }
                ecmKey = NamespacedKey.fromString((String)(module.getName().toLowerCase() + "/" + armorMaterial), (Plugin)pluginNamespace);
            } else {
                ecmKey = NamespacedKey.fromString((String)ecmStr, (Plugin)pluginNamespace);
            }
        }
        List lore = itemConfig.getStringList(lorePath);
        List itemFlags = itemConfig.getStringList(itemFlagsPath);
        ConfigurationSection enchantments = itemConfig.getConfigurationSection(enchantmentsPath);
        ConfigurationSection attributes = itemConfig.getConfigurationSection(attributesPath);
        ConfigurationSection nbtTags = itemConfig.getConfigurationSection(nbtTagsPath);
        ItemMeta meta = this.getItemMeta();
        ArrayList<String> newLore = new ArrayList<String>();
        if (material == Material.POTION) {
            Iterator colorPath = name + ".Color";
            String effectsPath = name + ".PotionType";
            if (itemConfig.getString((String)((Object)colorPath)) != null) {
                Color color = Utils.valueOfColor(itemConfig.getString(colorPath));
                ((PotionMeta)meta).setColor(color);
            }
            if (itemConfig.getString(effectsPath) != null) {
                String effect = itemConfig.getString(effectsPath);
                PotionType potionType = PotionType.valueOf((String)effect);
                ((PotionMeta)meta).setBasePotionData(new PotionData(potionType));
            }
        }
        if (displayName != null) {
            meta.setDisplayName(Utils.translateMsg(displayName, null, null));
        }
        if (lore != null && !lore.isEmpty()) {
            for (Object s2 : lore) {
                if (((String)s2).startsWith("LOREPRESET")) {
                    key = ((String)s2).substring(11);
                    LorePresets.useLorePreset(newLore, (String)key, module.getUserConfig().getConfig().getConfigurationSection("Items." + name));
                    continue;
                }
                newLore.add(Utils.translateMsg((String)s2, null, null));
            }
        }
        if (itemFlags != null && !itemFlags.isEmpty()) {
            for (Object s2 : itemFlags) {
                ItemFlag flag = ItemFlag.valueOf((String)s2);
                meta.addItemFlags(new ItemFlag[]{flag});
            }
        }
        if (enchantments != null) {
            Set enchantKeys = enchantments.getKeys(false);
            s2 = enchantKeys.iterator();
            while (s2.hasNext()) {
                String s3 = (String)s2.next();
                String mcName = Utils.getMinecraftEnchName(s3);
                Enchantment ench = EnchantmentWrapper.getByKey((NamespacedKey)NamespacedKey.minecraft((String)mcName));
                int value = itemConfig.getInt(enchantmentsPath + "." + s3);
                if (ench == null || value <= 0) continue;
                meta.addEnchant(ench, value, true);
            }
        }
        if (attributes != null) {
            boolean useModuleConfig = itemConfig.getBoolean(attributesPath + ".UseModuleConfig");
            FileConfiguration atrConfig = useModuleConfig ? module.getUserConfig().getConfig() : itemConfig;
            attributesPath = useModuleConfig ? "Items." + name + ".Attributes" : attributesPath;
            LorePresets.addGearLore(newLore, material);
            if (atrConfig.getConfigurationSection(attributesPath) != null) {
                Set keys = atrConfig.getConfigurationSection(attributesPath).getKeys(false);
                keys.remove("UseModuleConfig");
                for (String s4 : keys) {
                    Attribute atr = Utils.translateInformalAttributeName(s4);
                    String atrName = Utils.toLowercaseAttributeName(atr);
                    double displayValue = atrConfig.getDouble(attributesPath + "." + s4);
                    double correctValue = Utils.getCorrectAttributeValue(atr, displayValue);
                    EquipmentSlot slot = Utils.getCorrectEquipmentSlot(atr, material);
                    if (atrName == null) continue;
                    AttributeModifier atrMod = new AttributeModifier(UUID.randomUUID(), atrName, correctValue, AttributeModifier.Operation.ADD_NUMBER, slot);
                    LorePresets.addGearStats(newLore, atr, displayValue);
                    meta.addAttributeModifier(atr, atrMod);
                }
            }
        }
        if (!newLore.isEmpty()) {
            meta.setLore(newLore);
        }
        if (customModelData > 0) {
            meta.setCustomModelData(Integer.valueOf(customModelData));
        }
        if (itemModelKey != null) {
            Utils.setItemModel(meta, itemModelKey);
        }
        if (ecmKey != null) {
            Utils.setEquippableComponentModel(meta, ecmKey, Utils.getEquipmentSlotFromMaterial(material));
        }
        this.setItemMeta(meta);
        if (nbtTags != null) {
            Iterator useModuleConfig = nbtTags.getKeys(false).iterator();
            while (useModuleConfig.hasNext()) {
                key = s2 = (String)useModuleConfig.next();
                String value = itemConfig.getString(nbtTagsPath + "." + (String)s2);
                if (key == null || ((String)key).isEmpty() || value == null || value.isEmpty()) continue;
                if (NumberUtils.isDigits((String)value)) {
                    Utils.addNbtTag(this, (String)key, Integer.valueOf(Integer.parseInt(value)), PersistentDataType.INTEGER);
                    continue;
                }
                Utils.addNbtTag(this, (String)key, value, PersistentDataType.STRING);
            }
        }
        if (itemConfig.contains(repairIngPath)) {
            String raw = itemConfig.getString(repairIngPath);
            this.repairIng = new Ingredient(raw);
        } else {
            this.repairIng = new Ingredient("");
            Set<Material> vanilla = Utils.getVanillaRepairMaterials(this.getType());
            this.repairIng.add(vanilla);
        }
        if (module != null) {
            Utils.addNbtTag(this, "rsvitem", this.name, PersistentDataType.STRING);
            Utils.addNbtTag(this, "rsvmodule", module.getName(), PersistentDataType.STRING);
        }
        itemMap.put(name, this);
    }

    @Nonnull
    public Ingredient getRepairIng() {
        return this.repairIng;
    }

    @Nonnull
    public RSVItem resize(@Nonnegative int amount) {
        this.setAmount(amount);
        return this;
    }

    public static boolean isRSVItem(@Nullable ItemStack item) {
        if (Utils.isItemReal(item)) {
            return Utils.hasNbtTag(item, "rsvitem");
        }
        return false;
    }

    public static boolean isRSVItem(@Nonnull String name) {
        return itemMap.containsKey(name);
    }

    @Nullable
    public static ItemStack convertItemStackToRSVItem(@Nullable ItemStack item) {
        return RSVItem.isRSVItem(item) ? RSVItem.getItem(RSVItem.getNameFromItem(item)) : item;
    }

    public static <T> void addNbtTag(ItemStack item, String key, T obj, PersistentDataType<T, T> type) {
        Utils.addNbtTag(item, key, obj, type);
    }

    @Nullable
    public static String getModuleNameFromItem(@Nonnull ItemStack item) {
        return (String)Utils.getNbtTag(item, "rsvmodule", PersistentDataType.STRING);
    }

    @Nullable
    public static String getNameFromItem(@Nonnull ItemStack item) {
        return (String)Utils.getNbtTag(item, "rsvitem", PersistentDataType.STRING);
    }

    @Nullable
    public String getModule() {
        return this.module;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public static boolean isHoldingItem(@Nonnull String name, @Nonnull Player player) {
        return RSVItem.isHoldingItemInMainHand(name, player) || RSVItem.isHoldingItemInOffHand(name, player);
    }

    public static boolean isHoldingItemInMainHand(@Nonnull String name, @Nonnull Player player) {
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        return RSVItem.isRSVItem(mainHand) && RSVItem.getNameFromItem(mainHand).equals(name);
    }

    public static boolean isHoldingItemInOffHand(@Nonnull String name, @Nonnull Player player) {
        ItemStack offHand = player.getInventory().getItemInOffHand();
        return RSVItem.isRSVItem(offHand) && RSVItem.getNameFromItem(offHand).equals(name);
    }

    public static Map<String, RSVItem> getItemMap() {
        return itemMap;
    }

    @Nullable
    public static RSVItem getItem(@Nullable String name) {
        if (name == null) {
            return null;
        }
        RSVItem item = itemMap.get(name);
        if (item != null) {
            return new RSVItem(item);
        }
        Material material = Material.matchMaterial((String)name.toUpperCase());
        if (material != null) {
            return new RSVItem(material);
        }
        return null;
    }
}

