/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.val_mobile.data.RSVModule;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.Utils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public interface RSVMob {
    public List<String> getRequiredModules();

    public String getParentModule();

    public String name();

    public static boolean isMob(Entity entity) {
        return Utils.hasNbtTag(entity, "rsvmob");
    }

    public static String getMob(Entity entity) {
        return (String)Utils.getNbtTag(entity, "rsvmob", PersistentDataType.STRING);
    }

    public void addNbtData();

    public Collection<ItemStack> getLoot(@Nullable ItemStack var1);

    @Nonnull
    default public Collection<ItemStack> getConfigurableLoot(@Nullable ItemStack tool) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        FileConfiguration config = RSVModule.getModule(this.getParentModule()).getUserConfig().getConfig();
        if (config.contains("MobDrops." + this.name())) {
            ConfigurationSection section = config.getConfigurationSection("MobDrops." + this.name());
            Set itemKeys = section.getKeys(false);
            for (String itemKey : itemKeys) {
                if (!RSVItem.isRSVItem(itemKey)) continue;
                loot.add(Utils.getMobLoot(section.getConfigurationSection(itemKey), RSVItem.getItem(itemKey), tool, true));
            }
        }
        return loot;
    }

    default public void setup() {
        this.addNbtData();
        this.applyConfigOptions();
    }

    default public void applyConfigOptions() {
        Entity entity = this.getEntity();
        String name = this.name();
        name = name.contains("_") ? StringUtils.capitalize((String)name.substring(0, name.indexOf("_"))) + StringUtils.capitalize((String)name.substring(name.indexOf("_") + 1)) : name;
        name = StringUtils.capitalize((String)name);
        ConfigurationSection section = RSVModule.getModule(this.getParentModule()).getUserConfig().getConfig().getConfigurationSection(name + ".Info");
        entity.setCustomName(Utils.translateMsg(section.getString("Name"), (CommandSender)entity, null));
        entity.setCustomNameVisible(section.getBoolean("CustomNameVisible"));
        if (entity instanceof LivingEntity) {
            double maxHealth;
            LivingEntity living = (LivingEntity)entity;
            double minHealth = section.getDouble("Health.Min");
            double health = Utils.getRandomNum(minHealth, maxHealth = section.getDouble("Health.Max"));
            if (health > living.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()) {
                living.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
            }
            living.setHealth(health);
        }
    }

    public Entity getEntity();

    public void addEntityToWorld(World var1);
}

