/*
 * Decompiled with CFR 0.152.
 */
package me.val_mobile.utils.recipe;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import me.val_mobile.rsv.RSVPlugin;
import me.val_mobile.utils.Ingredient;
import me.val_mobile.utils.RSVItem;
import me.val_mobile.utils.recipe.RSVRecipe;
import me.val_mobile.utils.recipe.RecipeIngredient;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;

public class RSVShapelessRecipe
extends ShapelessRecipe
implements RSVRecipe {
    private final ItemStack result;
    private final Collection<RecipeIngredient> ingredients = new ArrayList<RecipeIngredient>();

    public RSVShapelessRecipe(@Nonnull FileConfiguration config, @Nonnull String name, @Nonnull RSVPlugin plugin) {
        super(new NamespacedKey((Plugin)plugin, name), RSVRecipe.getResult(config, name));
        this.result = RSVItem.getItem(name + ".Result");
        String ingredientsPath = name + ".Ingredients";
        for (String text : config.getStringList(ingredientsPath)) {
            if (!Ingredient.isValid(text)) continue;
            this.ingredients.add(new RecipeIngredient(text));
        }
        this.ingredients.forEach(ing -> this.addIngredient(ing.getRecipeChoice()));
    }

    public boolean isValidRecipe(@Nonnull CraftingInventory inv) {
        for (RecipeIngredient ingredient : this.ingredients) {
            if (ingredient.test(inv)) continue;
            return false;
        }
        return true;
    }

    public void useRecipe(@Nonnull PrepareItemCraftEvent e) {
        e.getInventory().setResult(this.result);
    }
}

