/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import java.io.Closeable;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.CaxtonModClient;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonConfig {
    public static final String CONFIG_PATH_STR = "config/caxton.json";
    public static final Path CONFIG_PATH = Path.of("config/caxton.json", new String[0]);
    public static final Path CONFIG_DIR = CONFIG_PATH.getParent();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().setStrictness(Strictness.LENIENT).create();
    @Nullable
    public String rustTarget = null;
    public boolean tweakExpText = true;
    public boolean sortTextRenderLayers = false;
    public boolean fatalOnBrokenMethodCall = false;
    public boolean debugRefcountChanges = false;
    public boolean disableEasterEggs = false;

    public CaxtonConfig() {
        boolean isImmediatelyFastLoaded = CaxtonModClient.getPlatformHooks().isModLoaded("immediatelyfast");
        if (isImmediatelyFastLoaded && !CaxtonModClient.getBatchingApi().isEnabled()) {
            this.tweakExpText = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CaxtonConfig readFromFile() {
        CaxtonConfig config;
        Closeable fh;
        try {
            fh = new FileReader(CONFIG_PATH_STR, StandardCharsets.UTF_8);
            try {
                try {
                    config = (CaxtonConfig)GSON.fromJson((Reader)fh, CaxtonConfig.class);
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    CaxtonModClient.LOGGER.error("Invalid config: ", e);
                    CaxtonModClient.LOGGER.error("Falling back to default config");
                    CaxtonConfig caxtonConfig = new CaxtonConfig();
                    ((InputStreamReader)fh).close();
                    return caxtonConfig;
                }
            }
            finally {
                ((InputStreamReader)fh).close();
            }
        }
        catch (IOException e) {
            config = new CaxtonConfig();
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                try {
                    Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
                }
                catch (IOException e2) {
                    CaxtonModClient.LOGGER.error("Could not create config directory: ", (Throwable)e);
                }
            }
            CaxtonModClient.LOGGER.error("Could not read from config file:  ", (Throwable)e);
        }
        try {
            fh = new FileWriter(CONFIG_PATH_STR, StandardCharsets.UTF_8);
            try {
                GSON.toJson((Object)config, (Appendable)((Object)fh));
                return config;
            }
            finally {
                ((OutputStreamWriter)fh).close();
            }
        }
        catch (IOException ex) {
            CaxtonModClient.LOGGER.error("Could not write to config file: ", (Throwable)ex);
        }
        return config;
    }
}

