/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.providers.GlyphProviderType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import xyz.flirora.caxton.CaxtonConfig;
import xyz.flirora.caxton.PlatformHooks;
import xyz.flirora.caxton.compat.immediatelyfast.BatchingApi;
import xyz.flirora.caxton.dll.LibraryLoading;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonModClient {
    public static final String MOD_ID = "caxton";
    public static final List<String> BUILTIN_PACKS = ImmutableList.of((Object)"inter", (Object)"opensans");
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean APRIL_FOOLS = CaxtonModClient.isAprilFools();
    private static final Set<String> CALLSITE_BLACKLIST = ImmutableSet.of((Object)StringSplitter.class.getName(), (Object)Font.class.getName());
    private static final ConcurrentMap<StackTraceElement, StackTraceElement> PREVIOUS_BROKEN_METHOD_CALLERS = new ConcurrentHashMap<StackTraceElement, StackTraceElement>();
    private static PlatformHooks platformHooks;
    private static BatchingApi batchingApi;
    public static final GlyphProviderType CAXTON_FONT_TYPE;
    public static boolean FORCE_DISABLE_BATCHING_HACK;
    public static CaxtonConfig CONFIG;

    private static GlyphProviderType getCaxtonFontType() {
        for (GlyphProviderType variant : (GlyphProviderType[])GlyphProviderType.class.getEnumConstants()) {
            if (!variant.name().equals("CAXTON")) continue;
            return variant;
        }
        throw new EnumConstantNotPresentException(GlyphProviderType.class, "Could not find CAXTON font type");
    }

    private static boolean isAprilFools() {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        return calendar.get(2) == 3 && calendar.get(5) == 1;
    }

    public static void onBrokenMethod() {
        int i;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (i = 4; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            if (CALLSITE_BLACKLIST.contains(className)) continue;
            if (PREVIOUS_BROKEN_METHOD_CALLERS.put(stackTrace[i], stackTrace[i]) == null) break;
            return;
        }
        LOGGER.warn("Use of {}.{} detected.", (Object)stackTrace[3].getClassName(), (Object)stackTrace[3].getMethodName());
        for (i = 3; i < stackTrace.length; ++i) {
            LOGGER.warn("    at " + stackTrace[i].toString());
        }
        LOGGER.warn("Do not use this method; its API is fundamentally broken.");
        if (CaxtonModClient.CONFIG.fatalOnBrokenMethodCall) {
            throw new UnsupportedOperationException();
        }
    }

    public static PlatformHooks getPlatformHooks() {
        return platformHooks;
    }

    public static BatchingApi getBatchingApi() {
        return batchingApi;
    }

    public static void init(PlatformHooks platformHooks) {
        CaxtonModClient.platformHooks = platformHooks;
        batchingApi = BatchingApi.createImpl(platformHooks);
        FORCE_DISABLE_BATCHING_HACK = platformHooks.isModLoaded("iris");
        LOGGER.info(APRIL_FOOLS ? "Ufhed Gaadn ghap Muzsar!" : "Initializing mod...");
        CONFIG = CaxtonConfig.readFromFile();
        LibraryLoading.loadNativeLibrary(LOGGER);
    }

    static {
        CAXTON_FONT_TYPE = CaxtonModClient.getCaxtonFontType();
        FORCE_DISABLE_BATCHING_HACK = false;
        CONFIG = null;
    }
}

