/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import xyz.flirora.caxton.command.ClientCommandSource;
import xyz.flirora.caxton.command.DebugShapeInfo;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonFontLoader;

public class ShapeCommand {
    private static final DynamicCommandExceptionType FONT_NOT_FOUND = new DynamicCommandExceptionType(id -> Component.translatable((String)"caxton.command.caxtonshape.fontNotFound", (Object[])new Object[]{id}));

    public static int run(CommandContext<?> context, ClientCommandSource source) throws CommandSyntaxException {
        ResourceLocation fontId = (ResourceLocation)context.getArgument("font", ResourceLocation.class);
        String text = (String)context.getArgument("text", String.class);
        CaxtonFont font = CaxtonFontLoader.getFontById(fontId);
        if (font == null) {
            throw FONT_NOT_FOUND.create((Object)fontId.toString());
        }
        DebugShapeInfo dsi = font.shapeForDebug(text);
        source.sendFeedback(() -> Component.translatable((String)"caxton.command.caxtonshape.shapingBuffer", (Object[])new Object[]{dsi.buffer}));
        source.sendFeedback(() -> Component.translatable((String)"caxton.command.caxtonshape.language", (Object[])new Object[]{dsi.inferredLanguage}));
        source.sendFeedback(() -> Component.translatable((String)"caxton.command.caxtonshape.script", (Object[])new Object[]{dsi.inferredScript}));
        source.sendFeedback(() -> Component.translatable((String)"caxton.command.caxtonshape.direction", (Object[])new Object[]{dsi.inferredDirection}));
        return 1;
    }
}

