/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import xyz.flirora.caxton.command.ClientCommandSource;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.Run;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingResult;
import xyz.flirora.caxton.layout.TextHandlerExt;

public class TextCommand {
    private static final Component RTL = Component.translatable((String)"caxton.command.caxtontext.rtl");
    private static final Component LTR = Component.translatable((String)"caxton.command.caxtontext.ltr");
    private static final Component IND1 = Component.literal((String)"\u2514 ").withStyle(ChatFormatting.YELLOW);
    private static final Component IND2 = Component.literal((String)" \u2514 ").withStyle(ChatFormatting.YELLOW);
    private static final Component IND3 = Component.literal((String)"  \u2514 ").withStyle(ChatFormatting.YELLOW);

    public static int run(CommandContext<?> context, ClientCommandSource source) throws CommandSyntaxException {
        CaxtonTextHandler cth = ((TextHandlerExt)source.getClient().font.getSplitter()).getCaxtonTextHandler();
        Component text = (Component)context.getArgument("text", Component.class);
        CaxtonText caxtonText = cth.layoutText(text.getVisualOrderText(), false, false);
        TextCommand.dump(source, caxtonText);
        return 1;
    }

    private static void dump(ClientCommandSource source, CaxtonText text) {
        source.sendFeedback(() -> Component.translatable((String)"caxton.command.caxtontext.summary", (Object[])new Object[]{TextCommand.escape(text.contents()), text.totalLength(), text.rtl() ? RTL : LTR}));
        for (RunGroup runGroup : text.runGroups()) {
            TextCommand.dump(source, runGroup);
        }
    }

    private static void dump(ClientCommandSource source, RunGroup runGroup) {
        String joinedStr = runGroup.getJoinedStr();
        source.sendFeedback(() -> IND1.copy().append((Component)Component.translatable((String)"caxton.command.caxtontext.runGroup.summary", (Object[])new Object[]{TextCommand.escape(joinedStr), runGroup.getCharOffset(), runGroup.getRunLevel()}).withStyle(ChatFormatting.AQUA)));
        for (Run styleRun : runGroup.getStyleRuns()) {
            if (styleRun.font() == null) {
                source.sendFeedback(() -> IND2.copy().append((Component)Component.translatable((String)"caxton.command.caxtontext.styleRun.summary.noFont", (Object[])new Object[]{TextCommand.escape(styleRun.text()), styleRun.style().toString()}).withStyle(ChatFormatting.GOLD)));
                continue;
            }
            source.sendFeedback(() -> IND2.copy().append((Component)Component.translatable((String)"caxton.command.caxtontext.styleRun.summary.font", (Object[])new Object[]{TextCommand.escape(styleRun.text()), styleRun.style(), styleRun.font().font().getId().toString()}).withStyle(ChatFormatting.GOLD)));
        }
        int[] bidiRuns = runGroup.getBidiRuns();
        int n = bidiRuns.length / 4;
        ShapingResult[] shapingResults = runGroup.getShapingResults();
        for (int i = 0; i < n; ++i) {
            int start = bidiRuns[4 * i + 0];
            int end = bidiRuns[4 * i + 1];
            int level = bidiRuns[4 * i + 2];
            int scriptInt = bidiRuns[4 * i + 3];
            String script = new String(new char[]{(char)(scriptInt >>> 24 & 0xFF), (char)(scriptInt >>> 16 & 0xFF), (char)(scriptInt >>> 8 & 0xFF), (char)(scriptInt & 0xFF)});
            source.sendFeedback(() -> IND2.copy().append((Component)Component.translatable((String)"caxton.command.caxtontext.bidiRun.summary", (Object[])new Object[]{TextCommand.escape(joinedStr.substring(start, end)), start, end, level, script}).withStyle(ChatFormatting.GREEN)));
            if (shapingResults == null || runGroup.getFont() == null) continue;
            TextCommand.dump(source, shapingResults[i], runGroup.getFont());
        }
    }

    private static void dump(ClientCommandSource source, ShapingResult shapingResult, ConfiguredCaxtonFont configuredFont) {
        CaxtonFont font = configuredFont.font();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        shapingResult.serializeGlyphs(builder, font);
        builder.append(']');
        source.sendFeedback(() -> IND3.copy().append((Component)Component.translatable((String)"caxton.command.caxtontext.shapingResult.summary", (Object[])new Object[]{builder.toString(), shapingResult.totalWidth()}).withStyle(ChatFormatting.LIGHT_PURPLE)));
    }

    private static String escape(String s) {
        return StringTag.quoteAndEscape((String)s);
    }
}

