/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.command.DebugShapeInfo;
import xyz.flirora.caxton.dll.CaxtonInternal;
import xyz.flirora.caxton.font.CaxtonFontOptions;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonFont
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static String cacheDir = null;
    private final ResourceLocation id;
    private final short[] metrics;
    private final int glyphCount;
    private final int tlistEntryCount;
    private final long[] tlistLocations;
    private final long bboxes;
    private final CaxtonFontOptions options;
    private final Int2ObjectMap<IntList> glyphsByWidth;
    private final long[] pixelData;
    private final NativeImage.Format format;
    private ByteBuffer fontData;
    private long fontPtr;
    private AtomicInteger refCount = new AtomicInteger(1);
    private final List<ChangeEntry> changes;

    public CaxtonFont(InputStream input, ResourceLocation id, JsonObject options) throws IOException {
        this.id = id;
        try {
            byte[] readInput = input.readAllBytes();
            this.fontData = MemoryUtil.memAlloc((int)readInput.length);
            this.fontData.put(readInput);
            this.fontPtr = CaxtonInternal.createFont(this.fontData, this.getCacheDir(), options.toString());
            this.metrics = CaxtonInternal.fontMetrics(this.fontPtr);
            this.glyphCount = CaxtonInternal.fontAtlasSize(this.fontPtr);
            this.tlistEntryCount = CaxtonInternal.fontAtlasPhysicalSize(this.fontPtr);
            this.bboxes = CaxtonInternal.fontBboxes(this.fontPtr);
            int mipmapLayers = CaxtonInternal.fontMipmapLayers(this.fontPtr);
            if (mipmapLayers <= 0) {
                throw new IllegalArgumentException("mipmapLayers must be at least 1");
            }
            if (mipmapLayers > 5) {
                throw new IllegalArgumentException("mipmapLayers must be at most 5");
            }
            this.tlistLocations = new long[mipmapLayers];
            this.pixelData = new long[mipmapLayers];
            for (int i = 0; i < mipmapLayers; ++i) {
                this.tlistLocations[i] = CaxtonInternal.fontAtlasLocations(this.fontPtr, i);
                this.pixelData[i] = CaxtonInternal.fontAtlasPage(this.fontPtr, i);
            }
            this.format = switch (CaxtonInternal.fontBytesPerPixel(this.fontPtr)) {
                case 1 -> NativeImage.Format.LUMINANCE;
                case 2 -> NativeImage.Format.LUMINANCE_ALPHA;
                case 3 -> NativeImage.Format.RGB;
                case 4 -> NativeImage.Format.RGBA;
                default -> throw new UnsupportedOperationException("caxton_impl returned an unsupported value for bytes per pixel");
            };
            this.options = new CaxtonFontOptions(options);
            this.glyphsByWidth = new Int2ObjectOpenHashMap();
            for (int glyphId = 0; glyphId < this.glyphCount; ++glyphId) {
                long tlLoc = MemoryUtil.memGetLong((long)(this.tlistLocations[0] + 8L * Integer.toUnsignedLong(glyphId)));
                int width = (int)(tlLoc & 0xFFFFL);
                ((IntList)this.glyphsByWidth.computeIfAbsent(width, w -> new IntArrayList())).add(glyphId);
            }
            this.changes = CaxtonModClient.CONFIG.debugRefcountChanges ? Collections.synchronizedList(new ArrayList()) : null;
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        int remainingRefs = this.refCount.decrementAndGet();
        if (remainingRefs < 0) {
            LOGGER.error("ERROR: Font closed with a refcount of 0.");
            this.logRefcountChanges();
            throw new IllegalStateException("font closed with a refcount of 0");
        }
        if (remainingRefs == 0) {
            if (this.fontPtr != 0L) {
                CaxtonInternal.destroyFont(this.fontPtr);
            }
            this.fontPtr = 0L;
            MemoryUtil.memFree((Buffer)this.fontData);
            this.fontData = null;
        }
        if (this.changes != null) {
            this.changes.add(ChangeEntry.capture(false));
        }
    }

    public String toString() {
        return "CaxtonFont[" + String.valueOf(this.id) + "@" + Long.toHexString(this.fontPtr) + "]";
    }

    public boolean supportsCodePoint(int codePoint) {
        return CaxtonInternal.fontGlyphIndex(this.fontPtr, codePoint) != -1;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public short getMetrics(int i) {
        return this.metrics[i];
    }

    public CaxtonFontOptions getOptions() {
        return this.options;
    }

    public long getFontPtr() {
        return this.fontPtr;
    }

    public int getNumMipmapLevels() {
        return this.tlistLocations.length;
    }

    public long getTlistLocation(int glyphId, int mipmap) {
        if (glyphId < 0 || glyphId >= this.tlistEntryCount) {
            throw new IndexOutOfBoundsException("i must be in [0, " + this.tlistEntryCount + ") (got " + glyphId + ")");
        }
        return MemoryUtil.memGetLong((long)(this.tlistLocations[mipmap] + 8L * Integer.toUnsignedLong(glyphId)));
    }

    public long getBbox(int glyphId) {
        if (glyphId < 0 || glyphId >= this.glyphCount) {
            throw new IndexOutOfBoundsException("i must be in [0, " + this.glyphCount + ") (got " + glyphId + ")");
        }
        return MemoryUtil.memGetLong((long)(this.bboxes + 8L * Integer.toUnsignedLong(glyphId)));
    }

    public long getPixelData(int mipmap) {
        return this.pixelData[mipmap];
    }

    public NativeImage.Format getPixelFormat() {
        return this.format;
    }

    public Int2ObjectMap<IntList> getGlyphsByWidth() {
        return this.glyphsByWidth;
    }

    @Nullable
    public String getGlyphName(int id) {
        return CaxtonInternal.fontGlyphName(this.fontPtr, id);
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public int getTlistSize() {
        return this.tlistEntryCount;
    }

    public DebugShapeInfo shapeForDebug(String s) {
        return CaxtonInternal.fontShapeForDebug(this.fontPtr, s);
    }

    private String getCacheDir() {
        if (cacheDir == null) {
            File dir = new File(Minecraft.getInstance().gameDirectory, "caxton_cache");
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            cacheDir = dir.getAbsolutePath();
        }
        return cacheDir;
    }

    public CaxtonFont cloneReference() {
        if (this.changes != null) {
            this.changes.add(ChangeEntry.capture(true));
        }
        this.refCount.incrementAndGet();
        return this;
    }

    private void logRefcountChanges() {
        if (this.changes != null) {
            LOGGER.error("Refcount changes:");
            for (ChangeEntry change : this.changes) {
                change.log(LOGGER);
            }
        }
    }

    private record ChangeEntry(Thread thread, StackTraceElement[] stackTrace, boolean added) {
        private static ChangeEntry capture(boolean added) {
            Thread currentThread = Thread.currentThread();
            return new ChangeEntry(currentThread, currentThread.getStackTrace(), added);
        }

        private void log(Logger logger) {
            logger.error(this.added ? "Reference added in thread {}:" : "Reference removed in thread {}:", (Object)this.thread);
            for (StackTraceElement elem : this.stackTrace) {
                logger.error(elem.toString());
            }
        }
    }

    public static class Metrics {
        public static int UNITS_PER_EM = 0;
        public static int ASCENDER = 1;
        public static int DESCENDER = 2;
        public static int HEIGHT = 3;
        public static int LINE_GAP = 4;
        public static int UNDERLINE_POSITION = 5;
        public static int UNDERLINE_THICKNESS = 6;
        public static int STRIKEOUT_POSITION = 7;
        public static int STRIKEOUT_THICKNESS = 8;
    }
}

