/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.gui.font.providers.GlyphProviderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.dll.LibraryLoading;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonTypeface;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonFontLoader
implements GlyphProviderDefinition {
    public static final String FONT_PREFIX = "textures/font/";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceLocation, CaxtonFont> CACHE = new ConcurrentHashMap<ResourceLocation, CaxtonFont>();
    private static final JsonObject EMPTY = new JsonObject();
    private final ConfiguredCaxtonFont.Loader regular;
    @Nullable
    private final ConfiguredCaxtonFont.Loader bold;
    @Nullable
    private final ConfiguredCaxtonFont.Loader italic;
    @Nullable
    private final ConfiguredCaxtonFont.Loader boldItalic;
    public static final MapCodec<CaxtonFontLoader> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ConfiguredCaxtonFont.Loader.CODEC.fieldOf("regular").forGetter(x -> x.regular), (App)ConfiguredCaxtonFont.Loader.CODEC.optionalFieldOf("bold").forGetter(x -> Optional.ofNullable(x.bold)), (App)ConfiguredCaxtonFont.Loader.CODEC.optionalFieldOf("italic").forGetter(x -> Optional.ofNullable(x.italic)), (App)ConfiguredCaxtonFont.Loader.CODEC.optionalFieldOf("bold_italic").forGetter(x -> Optional.ofNullable(x.boldItalic))).apply((Applicative)instance, (regular, bold, italic, boldItalic) -> new CaxtonFontLoader((ConfiguredCaxtonFont.Loader)regular, bold.orElse(null), italic.orElse(null), boldItalic.orElse(null))));

    public CaxtonFontLoader(ConfiguredCaxtonFont.Loader regular, @Nullable ConfiguredCaxtonFont.Loader bold, @Nullable ConfiguredCaxtonFont.Loader italic, @Nullable ConfiguredCaxtonFont.Loader boldItalic) {
        this.regular = regular;
        this.bold = bold;
        this.italic = italic;
        this.boldItalic = boldItalic;
    }

    @Nullable
    public static CaxtonFont loadFontByIdentifier(ResourceManager manager, @Nullable ResourceLocation id) {
        if (id == null) {
            return null;
        }
        return CACHE.computeIfAbsent(id, id1 -> {
            CaxtonFont caxtonFont;
            block17: {
                LOGGER.info("Loading font {}", (Object)id);
                ResourceLocation fontId = id1.withPrefix(FONT_PREFIX);
                ResourceLocation metaId = fontId.withPath(path -> path + ".json");
                JsonObject optionsJson = EMPTY;
                Optional metaResource = manager.getResource(metaId);
                if (metaResource.isPresent()) {
                    try (BufferedReader metaInput = ((Resource)metaResource.get()).openAsReader();){
                        optionsJson = GsonHelper.parse((Reader)metaInput);
                        String path2 = GsonHelper.getAsString((JsonObject)optionsJson, (String)"path", null);
                        if (path2 != null) {
                            fontId = ResourceLocation.parse((String)path2).withPrefix(FONT_PREFIX);
                        }
                    }
                }
                InputStream input = manager.open(fontId);
                try {
                    caxtonFont = new CaxtonFont(input, (ResourceLocation)id1, optionsJson);
                    if (input == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                input.close();
            }
            return caxtonFont;
        }).cloneReference();
    }

    public static void clearFontCache() {
        LOGGER.info("Clearing {} loaded font(s)", (Object)CACHE.size());
        CACHE.forEach((id, font) -> font.close());
        CACHE.clear();
    }

    public static CaxtonFont getFontById(ResourceLocation id) {
        return CACHE.get(id);
    }

    public static Stream<ResourceLocation> getAvailableFontIds() {
        System.err.println(CACHE);
        return CACHE.keySet().stream();
    }

    @Nullable
    public GlyphProvider load(ResourceManager manager) throws IOException {
        if (!LibraryLoading.isLibraryLoaded()) {
            throw new IOException("Refusing to load Caxton font when native library loading had failed");
        }
        try {
            ConfiguredCaxtonFont regular = ConfiguredCaxtonFont.load(manager, this.regular);
            ConfiguredCaxtonFont bold = ConfiguredCaxtonFont.load(manager, this.bold);
            ConfiguredCaxtonFont italic = ConfiguredCaxtonFont.load(manager, this.italic);
            ConfiguredCaxtonFont boldItalic = ConfiguredCaxtonFont.load(manager, this.boldItalic);
            return new CaxtonTypeface(regular, bold, italic, boldItalic);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load truetype font", (Throwable)exception);
            throw new IOException(exception);
        }
    }

    public Either<GlyphProviderDefinition.Loader, GlyphProviderDefinition.Reference> unpack() {
        return Either.left(this::load);
    }

    public GlyphProviderType type() {
        return CaxtonModClient.CAXTON_FONT_TYPE;
    }
}

