/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.FontTech;

@OnlyIn(value=Dist.CLIENT)
public record CaxtonFontOptions(FontTech fontTech, double shrinkage, int margin, int range, Invert invert, boolean forceBlur) {
    public CaxtonFontOptions {
        if (shrinkage <= 0.0) {
            throw new IllegalArgumentException("shrinkage must be positive");
        }
        if (margin < 0) {
            margin = range;
        }
        if (range <= 0) {
            throw new IllegalArgumentException("range must be positive");
        }
        if (range >= 256) {
            throw new IllegalArgumentException("range cannot be greater than 255");
        }
    }

    public CaxtonFontOptions(JsonObject json) {
        this(FontTech.fromName(GsonHelper.getAsString((JsonObject)json, (String)"tech", (String)"msdf")), GsonHelper.getAsDouble((JsonObject)json, (String)"shrinkage", (double)32.0), GsonHelper.getAsInt((JsonObject)json, (String)"margin", (int)-1), GsonHelper.getAsInt((JsonObject)json, (String)"range", (int)4), Invert.fromJson(json.get("invert")), GsonHelper.getAsBoolean((JsonObject)json, (String)"blur", (boolean)false));
    }

    public boolean blur() {
        return this.fontTech == FontTech.MSDF || this.forceBlur;
    }

    public static enum Invert {
        UNSET,
        FALSE,
        TRUE;


        public static Invert fromJson(@Nullable JsonElement json) {
            if (json == null || json.isJsonNull()) {
                return UNSET;
            }
            try {
                boolean b = json.getAsBoolean();
                return b ? TRUE : FALSE;
            }
            catch (Exception e) {
                throw new JsonSyntaxException("invert must be true, false, or null", (Throwable)e);
            }
        }
    }
}

