/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.UnbakedGlyph;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.network.chat.Style;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonTypeface
implements GlyphProvider {
    private ConfiguredCaxtonFont regular;
    @Nullable
    private ConfiguredCaxtonFont bold;
    @Nullable
    private ConfiguredCaxtonFont italic;
    @Nullable
    private ConfiguredCaxtonFont boldItalic;

    public CaxtonTypeface(ConfiguredCaxtonFont regular, @Nullable ConfiguredCaxtonFont bold, @Nullable ConfiguredCaxtonFont italic, @Nullable ConfiguredCaxtonFont boldItalic) {
        this.regular = regular;
        this.bold = bold;
        this.italic = italic;
        this.boldItalic = boldItalic;
    }

    public void close() {
        if (this.regular != null) {
            this.regular.close();
        }
        if (this.bold != null) {
            this.bold.close();
        }
        if (this.italic != null) {
            this.italic.close();
        }
        if (this.boldItalic != null) {
            this.boldItalic.close();
        }
        this.regular = null;
        this.bold = null;
        this.italic = null;
        this.boldItalic = null;
        super.close();
    }

    @Nullable
    public UnbakedGlyph getGlyph(int codePoint) {
        return null;
    }

    public IntSet getSupportedGlyphs() {
        return IntSets.emptySet();
    }

    public boolean supportsCodePoint(int codePoint, Style style) {
        return this.getFontByStyle(style).font().supportsCodePoint(codePoint);
    }

    public ConfiguredCaxtonFont getFontByStyle(Style style) {
        ConfiguredCaxtonFont font = style.isBold() ? (style.isItalic() ? this.boldItalic : this.bold) : (style.isItalic() ? this.italic : this.regular);
        return font == null ? this.regular : font;
    }

    public Stream<ConfiguredCaxtonFont> fonts() {
        return Stream.of(this.regular, this.bold, this.italic, this.boldItalic).filter(Objects::nonNull);
    }
}

