/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.forge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.command.CaxtonCommands;
import xyz.flirora.caxton.forge.ClientCommandRegistrarResourceLocationFlavor;
import xyz.flirora.caxton.forge.PlatformHooksResourceLocationFlavor;

@Mod(value="caxton")
public class CaxtonModResourceLocationFlavor {
    public CaxtonModResourceLocationFlavor(IEventBus modBus) {
        modBus.addListener(this::initCaxtonMod);
        NeoForge.EVENT_BUS.addListener(CaxtonModResourceLocationFlavor::registerCommands);
        modBus.addListener(this::addPackFinders);
    }

    private void initCaxtonMod(AddClientReloadListenersEvent event) {
        CaxtonModClient.init(new PlatformHooksResourceLocationFlavor());
    }

    private void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            CaxtonModClient.LOGGER.info("Registering built-in resource packs");
            for (String id : CaxtonModClient.BUILTIN_PACKS) {
                event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)"caxton", (String)("resourcepacks/" + id)), PackType.CLIENT_RESOURCES, (Component)Component.translatable((String)("caxton.resourcePack." + id)), PackSource.BUILT_IN, false, Pack.Position.TOP);
            }
        }
    }

    private static void registerCommands(RegisterClientCommandsEvent event) {
        CaxtonCommands.register(new ClientCommandRegistrarResourceLocationFlavor((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext()));
    }
}

