/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.BreakIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.ForwardTraversedMap;
import xyz.flirora.caxton.layout.Run;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingResult;

public class LineWrapper {
    private final CaxtonText text;
    private final Bidi bidi;
    @Nullable
    private final BreakIterator bi;
    private final String contents;
    private final float maxWidth;
    private final float[] widths;
    private final ForwardTraversedMap runGroupIndicesByStart;
    private int currentLineStart = 0;
    private int brIndex = 0;
    private int targetBreakPoint;
    private boolean continuation = false;

    public LineWrapper(CaxtonText text, Bidi bidi, StringSplitter.WidthProvider widthRetriever, float maxWidth, boolean breakAnywhere) {
        this.text = text;
        this.bidi = bidi;
        this.maxWidth = Math.max(maxWidth, 1.0f);
        this.contents = text.contents();
        if (breakAnywhere) {
            this.bi = null;
        } else {
            this.bi = BreakIterator.getLineInstance((Locale)Locale.getDefault());
            this.bi.setText(this.contents);
        }
        this.targetBreakPoint = this.nextEligibleBreakPoint();
        this.widths = new float[text.totalLength()];
        Arrays.fill(this.widths, Float.NaN);
        List<RunGroup> groups = text.runGroups();
        LongArrayList packedRunGroupStartIndexPairs = new LongArrayList();
        for (int k = 0; k < groups.size(); ++k) {
            RunGroup runGroup = groups.get(k);
            ConfiguredCaxtonFont font = runGroup.getFont();
            if (font == null) {
                runGroup.acceptRender((index, style, codePoint, rtl) -> {
                    float width = widthRetriever.getWidth(codePoint, style);
                    int index2 = index + runGroup.getCharOffset();
                    this.widths[index2] = width;
                    return true;
                });
            } else {
                int[] bidiRuns = runGroup.getBidiRuns();
                ShapingResult[] shapingResults = runGroup.getShapingResults();
                for (int j = 0; j < shapingResults.length; ++j) {
                    ShapingResult shapingResult = shapingResults[j];
                    int runStart = bidiRuns[4 * j + 0];
                    for (int i = 0; i < shapingResult.numGlyphs(); ++i) {
                        int index2 = shapingResult.clusterIndex(i);
                        int advance = shapingResult.advanceX(i);
                        float width = font.getScale() * (float)advance;
                        int index22 = index2 + runStart + runGroup.getCharOffset();
                        this.widths[index22] = width;
                    }
                }
            }
            packedRunGroupStartIndexPairs.add((long)k << 32 | (long)runGroup.getCharOffset());
        }
        packedRunGroupStartIndexPairs.sort((a, b) -> Integer.compare((int)a, (int)b));
        this.runGroupIndicesByStart = new ForwardTraversedMap();
        LongListIterator longListIterator = packedRunGroupStartIndexPairs.iterator();
        while (longListIterator.hasNext()) {
            long x = (Long)longListIterator.next();
            this.runGroupIndicesByStart.put((int)x, (int)(x >> 32));
        }
    }

    public int getCurrentLineStart() {
        return this.currentLineStart;
    }

    public Result nextLine(Function<ResourceLocation, FontSet> fontStorageAccessor) {
        int codePoint;
        int lastNonspace;
        boolean rtl = this.isCurrentlyRtl();
        int index = this.computeNextLineBreak();
        Run.RunLister lister = new Run.RunLister(fontStorageAccessor, false);
        for (lastNonspace = index; lastNonspace > this.currentLineStart && UCharacter.isWhitespace((int)this.contents.charAt(lastNonspace - 1)); --lastNonspace) {
        }
        for (int i = this.currentLineStart; i < lastNonspace; i += Character.charCount(codePoint)) {
            codePoint = this.contents.codePointAt(i);
            RunGroup group = this.getRunGroupAt(i);
            Style style = group.getStyleAt(i - group.getCharOffset());
            lister.accept(i - this.currentLineStart, style, codePoint);
        }
        this.currentLineStart = index;
        return new Result(lister.getRuns(), rtl);
    }

    public void goToNextLine() {
        this.currentLineStart = this.computeNextLineBreak();
    }

    public boolean isCurrentlyRtl() {
        while (this.brIndex < this.bidi.getRunCount() - 1 && this.currentLineStart >= this.bidi.getRunLimit(this.brIndex)) {
            ++this.brIndex;
        }
        return this.bidi.getRunLevel(this.brIndex) % 2 != 0;
    }

    public RunGroup getRunGroupAt(int index) {
        int k = this.runGroupIndicesByStart.inf(index + 1);
        return this.text.runGroups().get(k);
    }

    private int computeNextLineBreak() {
        float remainingLineWidth = this.maxWidth;
        int prevBreakPoint = -1;
        int prevIndex = -1;
        int index = this.currentLineStart;
        while (index < this.contents.length()) {
            if (this.contents.charAt(index) == '\n') {
                this.continuation = false;
                if (++index < this.targetBreakPoint) break;
                this.targetBreakPoint = this.nextEligibleBreakPoint();
                break;
            }
            if (index >= this.targetBreakPoint) {
                prevBreakPoint = this.targetBreakPoint;
                this.targetBreakPoint = this.nextEligibleBreakPoint();
            }
            if ((remainingLineWidth -= this.widths[index]) < 0.0f) {
                int candidateIndex;
                int n = candidateIndex = prevBreakPoint == -1 ? prevIndex : prevBreakPoint;
                if (candidateIndex == this.currentLineStart) break;
                index = candidateIndex;
                break;
            }
            prevIndex = index;
            index = this.nextIndex(index);
        }
        return index == -1 ? this.nextIndex(this.currentLineStart) : index;
    }

    private int nextEligibleBreakPoint() {
        if (this.bi == null) {
            return this.targetBreakPoint + 1;
        }
        return this.bi.next();
    }

    public boolean isContinuation() {
        return this.continuation;
    }

    public String getContents() {
        return this.contents;
    }

    public boolean isFinished() {
        return this.currentLineStart >= this.contents.length();
    }

    private int nextIndex(int i) {
        ++i;
        while (i < this.contents.length() && Float.isNaN(this.widths[i])) {
            ++i;
        }
        return i;
    }

    public record Result(List<Run> runs, boolean rtl) {
    }
}

