/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.CaxtonFontStorage;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.FcIndexConverter;

@OnlyIn(value=Dist.CLIENT)
public record Run(String text, Style style, @Nullable ConfiguredCaxtonFont font) {
    @NotNull
    public static List<Run> splitIntoRuns(FormattedCharSequence text, Function<ResourceLocation, FontSet> fonts, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        text.accept((FormattedCharSink)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsFormatted(FormattedText text, Function<ResourceLocation, FontSet> fonts, Style style, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        StringDecomposer.iterateFormatted((FormattedText)text, (Style)style, (FormattedCharSink)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsFormatted(String text, Function<ResourceLocation, FontSet> fonts, Style style, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        StringDecomposer.iterateFormatted((String)text, (Style)style, (FormattedCharSink)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsFormatted(String text, Function<ResourceLocation, FontSet> fonts, Style style, Style baseStyle, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        StringDecomposer.iterateFormatted((String)text, (int)0, (Style)style, (Style)baseStyle, (FormattedCharSink)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsForwards(FormattedText text, Function<ResourceLocation, FontSet> fonts, Style style, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        text.visit((style1, asString) -> {
            StringDecomposer.iterate((String)asString, (Style)style1.applyTo(style), (FormattedCharSink)lister);
            return Optional.empty();
        }, style);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsForwards(String text, Function<ResourceLocation, FontSet> fonts, Style style, boolean validateAdvance) {
        RunLister lister = new RunLister(fonts, validateAdvance);
        StringDecomposer.iterate((String)text, (Style)style, (FormattedCharSink)lister);
        return lister.getRuns();
    }

    @NotNull
    public static List<Run> splitIntoRunsFormatted(String text, Function<ResourceLocation, FontSet> fonts, Style style, boolean validateAdvance, FcIndexConverter formattingCodeStarts) {
        formattingCodeStarts.put(Integer.MIN_VALUE, 0);
        RunLister lister = new RunLister(fonts, validateAdvance);
        MutableInt numFormattingCodes = new MutableInt();
        StringDecomposer.iterateFormatted((String)text, (Style)style, (index, style1, codePoint) -> {
            if (index >= 2 && text.charAt(index - 2) == '\u00a7') {
                int numConsecutiveCodes = 1;
                for (int checkIndex = index - 4; checkIndex >= 0 && text.charAt(checkIndex) == '\u00a7'; checkIndex -= 2) {
                    ++numConsecutiveCodes;
                }
                int n = numFormattingCodes.addAndGet(numConsecutiveCodes);
                formattingCodeStarts.put(index - 2 * n, n);
            }
            return lister.accept(index, style1, codePoint);
        });
        return lister.getRuns();
    }

    public static class RunLister
    implements FormattedCharSink {
        private final List<PendingRun> runs = new ArrayList<PendingRun>();
        private final Function<ResourceLocation, FontSet> fonts;
        private final boolean validateAdvance;

        public RunLister(Function<ResourceLocation, FontSet> fonts, boolean validateAdvance) {
            this.fonts = fonts;
            this.validateAdvance = validateAdvance;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean accept(int index, Style style, int codePoint) {
            ConfiguredCaxtonFont font;
            FontDescription source = style.getFont();
            if (source instanceof FontDescription.Resource) {
                FontDescription.Resource resource = (FontDescription.Resource)source;
                try {
                    ResourceLocation resourceLocation;
                    ResourceLocation fontId = resourceLocation = resource.id();
                    v0 = ((CaxtonFontStorage)this.fonts.apply(fontId)).getCaxtonGlyph(codePoint, this.validateAdvance, style).getCaxtonFont();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            } else {
                v0 = font = null;
            }
            if (this.runs.isEmpty()) {
                this.addNewRun(codePoint, style, font);
                return true;
            }
            PendingRun lastRun = this.runs.getLast();
            if (lastRun.style.equals((Object)style) && lastRun.font == font) {
                lastRun.appendCodePoint(codePoint);
                return true;
            }
            this.addNewRun(codePoint, style, font);
            return true;
        }

        private void addNewRun(int codePoint, Style style, @Nullable ConfiguredCaxtonFont font) {
            this.runs.add(new PendingRun(new StringBuffer().appendCodePoint(codePoint), style, font));
        }

        public List<Run> getRuns() {
            return this.runs.stream().map(PendingRun::bake).collect(Collectors.toList());
        }
    }

    private static class PendingRun {
        private final StringBuffer contents;
        private final Style style;
        @Nullable
        private final ConfiguredCaxtonFont font;

        private PendingRun(StringBuffer contents, Style style, @Nullable ConfiguredCaxtonFont font) {
            this.contents = contents;
            this.style = style;
            this.font = font;
        }

        public void appendCodePoint(int codePoint) {
            this.contents.appendCodePoint(codePoint);
        }

        public Run bake() {
            String text = this.contents.toString();
            return new Run(text, this.style, this.font);
        }
    }
}

