/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import com.github.benmanes.caffeine.cache.Cache;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.ArabicShaping;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.DirectionalCharacterVisitor;
import xyz.flirora.caxton.layout.LayoutCache;
import xyz.flirora.caxton.layout.Run;
import xyz.flirora.caxton.layout.ShapedString;
import xyz.flirora.caxton.layout.ShapingResult;

@OnlyIn(value=Dist.CLIENT)
public class RunGroup {
    private final List<Run> styleRuns;
    private final String joinedStr;
    private final char[] joined;
    private final int runLevel;
    private final int charOffset;
    private final int[] bidiRuns;
    private final int @Nullable [] styleRunStarts;
    private final ShapingResult @Nullable [] shapingResults;
    private int lastQueriedStylePosition = 0;
    private int lastQueriedStyleResult = 0;

    public RunGroup(List<Run> styleRuns, int runLevel, int charOffset, int[] bidiRuns, @Nullable LayoutCache cache) {
        this.runLevel = runLevel;
        this.charOffset = charOffset;
        if (styleRuns.isEmpty()) {
            throw new IllegalArgumentException("runs may not be empty");
        }
        this.styleRuns = styleRuns;
        this.joinedStr = styleRuns.stream().map(Run::text).collect(Collectors.joining());
        this.joined = this.joinedStr.toCharArray();
        this.bidiRuns = bidiRuns;
        this.styleRunStarts = new int[styleRuns.size() + 1];
        int x = 0;
        for (int i = 0; i < styleRuns.size(); ++i) {
            this.styleRunStarts[i] = x;
            x += styleRuns.get(i).text().length();
        }
        this.styleRunStarts[styleRuns.size()] = x;
        this.shapingResults = styleRuns.get(0).font() == null ? null : (cache == null ? null : this.shape(cache));
    }

    public boolean accept(DirectionalCharacterVisitor visitor) {
        ArabicShaping shaper = new ArabicShaping(12);
        for (int i = 0; i < this.bidiRuns.length / 4; ++i) {
            int j;
            int start = this.bidiRuns[4 * i + 0];
            int end = this.bidiRuns[4 * i + 1];
            int level = this.bidiRuns[4 * i + 2];
            if (level % 2 != 0) {
                j = end;
                while (j > start) {
                    int c;
                    int cp = c = this.joined[j - 1];
                    if (Character.isLowSurrogate((char)c)) {
                        if (j >= start + 1 && Character.isHighSurrogate(this.joined[j - 2])) {
                            cp = Character.toCodePoint(this.joined[j - 2], (char)c);
                            --j;
                        } else {
                            cp = 65533;
                        }
                    } else if (Character.isHighSurrogate((char)c)) {
                        cp = 65533;
                    }
                    if (visitor.accept(--j, this.getStyleAt(j), UCharacter.getMirror((int)cp), true)) continue;
                    return false;
                }
                continue;
            }
            for (j = start; j < end; ++j) {
                int c;
                int k = j;
                int cp = c = this.joined[j];
                if (Character.isHighSurrogate((char)c)) {
                    if (j < end - 1 && Character.isLowSurrogate(this.joined[j + 1])) {
                        cp = Character.toCodePoint((char)c, this.joined[j + 1]);
                        ++j;
                        continue;
                    }
                    cp = 65533;
                    continue;
                }
                if (!Character.isLowSurrogate((char)c)) continue;
                cp = 65533;
                if (visitor.accept(k, this.getStyleAt(k), cp, false)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean accept(FormattedCharSink visitor) {
        return this.accept(DirectionalCharacterVisitor.fromCharacterVisitor(visitor));
    }

    public boolean acceptRender(FormattedCharSink visitor) {
        return this.accept(visitor);
    }

    public boolean acceptRender(DirectionalCharacterVisitor visitor) {
        return this.accept(visitor);
    }

    @Nullable
    public ConfiguredCaxtonFont getFont() {
        return this.styleRuns.get(0).font();
    }

    public String toString() {
        return "RunGroup[runs=" + String.valueOf(this.styleRuns) + ", bidiRuns=" + Arrays.toString(this.bidiRuns) + ", styleRunStarts=" + Arrays.toString(this.styleRunStarts) + ", charOffset=" + this.charOffset + ", runLevel=" + this.runLevel + ", #=" + this.joined.length + "]";
    }

    public List<Run> getStyleRuns() {
        return this.styleRuns;
    }

    public int[] getBidiRuns() {
        return this.bidiRuns;
    }

    public char[] getJoined() {
        return this.joined;
    }

    public String getJoinedStr() {
        return this.joinedStr;
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    public int getCharOffset() {
        return this.charOffset;
    }

    public int getTotalLength() {
        return this.joined.length;
    }

    public boolean containsIndex(int index) {
        return index >= this.charOffset && index < this.charOffset + this.joined.length;
    }

    public Style getStyleAt(int index) {
        int result = this.getStyleIndexAt(index);
        return this.styleRuns.get(result).style();
    }

    private int getStyleIndexAt(int index) {
        if (index < 0 || index >= this.joined.length) {
            throw new IndexOutOfBoundsException("index must be in [0, " + this.joined.length + "); got " + index);
        }
        int result = this.computeStyleIndexAt(index);
        this.lastQueriedStylePosition = index;
        this.lastQueriedStyleResult = result;
        return result;
    }

    private int computeStyleIndexAt(int index) {
        Objects.requireNonNull(this.styleRunStarts, "this method is not supported for legacy-font runs");
        if (index == this.lastQueriedStylePosition) {
            return this.lastQueriedStyleResult;
        }
        if (index == this.lastQueriedStylePosition + 1) {
            if (index >= this.styleRunStarts[this.lastQueriedStyleResult + 1]) {
                return this.lastQueriedStyleResult + 1;
            }
            return this.lastQueriedStyleResult;
        }
        if (index == this.lastQueriedStylePosition - 1) {
            if (this.lastQueriedStylePosition == this.styleRunStarts[this.lastQueriedStyleResult]) {
                return this.lastQueriedStyleResult - 1;
            }
            return this.lastQueriedStyleResult;
        }
        int result = Arrays.binarySearch(this.styleRunStarts, index);
        return result >= 0 ? result : -result - 2;
    }

    public ShapingResult @Nullable [] getShapingResults() {
        return this.shapingResults;
    }

    private ShapingResult[] shape(LayoutCache cache) {
        ConfiguredCaxtonFont font = this.getFont();
        if (font == null) {
            throw new UnsupportedOperationException("shapeRunGroup requires a Caxton font (got a legacy font)");
        }
        Cache<ShapedString, ShapingResult> shapingCacheForFont = cache.getShapingCacheFor(font);
        int[] bidiRuns = this.getBidiRuns();
        IntArrayList uncachedBidiRuns = new IntArrayList(bidiRuns.length);
        ShapingResult[] shapingResults = new ShapingResult[bidiRuns.length / 4];
        for (int i = 0; i < bidiRuns.length / 4; ++i) {
            int start = bidiRuns[4 * i + 0];
            int end = bidiRuns[4 * i + 1];
            int level = bidiRuns[4 * i + 2];
            int script = bidiRuns[4 * i + 3];
            String s = new String(this.getJoined(), start, end - start);
            ShapedString key = new ShapedString(s, level % 2 != 0);
            ShapingResult sr = (ShapingResult)shapingCacheForFont.getIfPresent((Object)key);
            if (sr != null) {
                shapingResults[i] = sr;
                continue;
            }
            uncachedBidiRuns.add(start);
            uncachedBidiRuns.add(end);
            uncachedBidiRuns.add(level);
            uncachedBidiRuns.add(script);
        }
        if (!uncachedBidiRuns.isEmpty()) {
            ShapingResult[] newlyComputed = font.shape(this.joined, uncachedBidiRuns.toIntArray());
            int j = 0;
            for (int i = 0; i < bidiRuns.length / 4; ++i) {
                if (shapingResults[i] != null) continue;
                shapingResults[i] = newlyComputed[j];
                int start = bidiRuns[4 * i + 0];
                int end = bidiRuns[4 * i + 1];
                int level = bidiRuns[4 * i + 2];
                String s = new String(this.getJoined(), start, end - start);
                ShapedString key = new ShapedString(s, level % 2 != 0);
                shapingCacheForFont.put((Object)key, (Object)newlyComputed[j]);
                ++j;
            }
        }
        return shapingResults;
    }
}

