/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import xyz.flirora.caxton.font.CaxtonFont;

@OnlyIn(value=Dist.CLIENT)
public record ShapingResult(int[] data, int totalWidth, int totalLength) {
    public ShapingResult {
        if (data.length % 6 != 0) {
            throw new IllegalArgumentException("length of data must be divisible by 6");
        }
    }

    public int numGlyphs() {
        return this.data.length / 6;
    }

    public int glyphId(int i) {
        return this.data[6 * i] & 0xFFFFFF;
    }

    public boolean isUnsafeToBreak(int i) {
        return (this.data[6 * i] & 0x1000000) != 0;
    }

    public int clusterIndex(int i) {
        return this.data[6 * i + 1];
    }

    private int leftboundLimit(int i) {
        int curr = this.clusterIndex(i);
        for (int j = i - 1; j >= 0; --j) {
            int prev = this.clusterIndex(j);
            if (prev == curr) continue;
            return prev;
        }
        return -1;
    }

    private int rightboundLimit(int i) {
        int curr = this.clusterIndex(i);
        for (int j = i + 1; j < this.numGlyphs(); ++j) {
            int next = this.clusterIndex(j);
            if (next == curr) continue;
            return next;
        }
        return -1;
    }

    public int clusterLimit(int i) {
        int curr = this.clusterIndex(i);
        int prev = this.leftboundLimit(i);
        int next = this.rightboundLimit(i);
        if (prev < 0 && next < curr) {
            prev = this.totalLength;
        }
        if (next < 0 && prev < curr) {
            next = this.totalLength;
        }
        return prev > next ? prev : next;
    }

    public int advanceX(int i) {
        return this.data[6 * i + 2];
    }

    public int advanceY(int i) {
        return this.data[6 * i + 3];
    }

    public int offsetX(int i) {
        return this.data[6 * i + 4];
    }

    public int offsetY(int i) {
        return this.data[6 * i + 5];
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("ShapingResult[glyphs=[");
        this.serializeGlyphs(builder, null);
        builder.append("], totalWidth=");
        builder.append(this.totalWidth);
        builder.append("]");
        return builder.toString();
    }

    public void serializeGlyphs(StringBuilder builder, CaxtonFont font) {
        for (int i = 0; i < this.numGlyphs(); ++i) {
            if (i > 0) {
                builder.append("|");
            }
            if (font != null) {
                builder.append(font.getGlyphName(this.glyphId(i)));
            } else {
                builder.append(this.glyphId(i));
            }
            if (this.isUnsafeToBreak(i)) {
                builder.append("!");
            }
            builder.append("=");
            builder.append(this.clusterIndex(i));
            int offsetX = this.offsetX(i);
            int offsetY = this.offsetY(i);
            int advanceX = this.advanceX(i);
            int advanceY = this.advanceY(i);
            if (offsetX != 0 || offsetY != 0) {
                builder.append("@");
                builder.append(offsetX);
                builder.append(",");
                builder.append(offsetY);
            }
            builder.append("+");
            builder.append(advanceX);
            if (advanceY == 0) continue;
            builder.append(",");
            builder.append(advanceY);
        }
    }
}

