/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.UnbakedGlyph;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.gui.font.FontOption;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.network.chat.Style;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.flirora.caxton.dll.LibraryLoading;
import xyz.flirora.caxton.font.CaxtonFontStorage;
import xyz.flirora.caxton.font.CaxtonGlyphPair;
import xyz.flirora.caxton.font.CaxtonGlyphResult;
import xyz.flirora.caxton.font.CaxtonTypeface;
import xyz.flirora.caxton.mixin.LazyBakedGlyphAccessor;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={FontSet.class})
public abstract class FontStorageMixin
implements AutoCloseable,
CaxtonFontStorage {
    @Unique
    private Int2ObjectMap<CaxtonGlyphPair>[] caxtonGlyphCache = null;
    @Shadow
    private List<GlyphProvider> activeProviders;
    @Shadow
    @Final
    private Supplier<BakedGlyph> missingGlyphGetter;

    @Shadow
    private static boolean hasFishyAdvance(GlyphInfo glyph) {
        return false;
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/client/gui/font/GlyphStitcher;)V"})
    private void init(CallbackInfo ci) {
        this.caxtonGlyphCache = new Int2ObjectMap[4];
        for (int i = 0; i < 4; ++i) {
            this.caxtonGlyphCache[i] = new Int2ObjectOpenHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"reload(Ljava/util/List;Ljava/util/Set;)V"})
    private void onSetFonts(List<GlyphProvider.Conditional> allFonts, Set<FontOption> activeFilters, CallbackInfo ci) {
        Int2ObjectMap<CaxtonGlyphPair>[] int2ObjectMapArray = this.caxtonGlyphCache;
        int n = int2ObjectMapArray.length;
        for (int i = 0; i < n; ++i) {
            Int2ObjectMap<CaxtonGlyphPair> cacheEntry;
            Int2ObjectMap<CaxtonGlyphPair> int2ObjectMap = cacheEntry = int2ObjectMapArray[i];
            synchronized (int2ObjectMap) {
                cacheEntry.clear();
                continue;
            }
        }
    }

    @Unique
    private Int2ObjectMap<CaxtonGlyphPair> getCacheForStyle(Style style) {
        return this.caxtonGlyphCache[(style.isBold() ? 2 : 0) | (style.isItalic() ? 1 : 0)];
    }

    @Redirect(method={"selectProviders(Ljava/util/List;Ljava/util/Set;)Ljava/util/List;"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;"))
    private Stream<GlyphProvider> filterProxy(Stream<GlyphProvider> allFonts, Predicate<GlyphProvider> predicate) {
        if (!LibraryLoading.isLibraryLoaded()) {
            return allFonts.filter(predicate);
        }
        return allFonts.filter(font -> {
            if (font instanceof CaxtonTypeface) {
                CaxtonTypeface c = (CaxtonTypeface)font;
                return true;
            }
            return predicate.test((GlyphProvider)font);
        });
    }

    @Unique
    private CaxtonGlyphPair findCaxtonGlyph(int codePoint, Style style) {
        FontSet.DelayedBake first = null;
        for (GlyphProvider font : this.activeProviders) {
            CaxtonTypeface caxtonFont;
            if (font instanceof CaxtonTypeface && (caxtonFont = (CaxtonTypeface)font).supportsCodePoint(codePoint, style)) {
                return new CaxtonGlyphPair.Caxton(caxtonFont.getFontByStyle(style));
            }
            UnbakedGlyph current = font.getGlyph(codePoint);
            if (current == null) continue;
            if (first == null) {
                first = LazyBakedGlyphAccessor.construct((FontSet)this, current);
            }
            if (FontStorageMixin.hasFishyAdvance(current.info())) continue;
            if (((LazyBakedGlyphAccessor)first).getGlyph() == current) {
                return new CaxtonGlyphPair.Legacy((Supplier<BakedGlyph>)first, (Supplier<BakedGlyph>)first);
            }
            return new CaxtonGlyphPair.Legacy((Supplier<BakedGlyph>)first, (Supplier<BakedGlyph>)LazyBakedGlyphAccessor.construct((FontSet)this, current));
        }
        if (first != null) {
            return new CaxtonGlyphPair.Legacy((Supplier<BakedGlyph>)first, this.missingGlyphGetter);
        }
        return new CaxtonGlyphPair.Legacy(this.missingGlyphGetter, this.missingGlyphGetter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaxtonGlyphResult getCaxtonGlyph(int codePoint, boolean validateAdvance, Style style) {
        Int2ObjectMap<CaxtonGlyphPair> cache;
        Int2ObjectMap<CaxtonGlyphPair> int2ObjectMap = cache = this.getCacheForStyle(style);
        synchronized (int2ObjectMap) {
            return ((CaxtonGlyphPair)cache.computeIfAbsent(codePoint, c -> this.findCaxtonGlyph(c, style))).getGlyph(validateAdvance);
        }
    }
}

