/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin;

import com.mojang.logging.LogUtils;
import java.util.function.BiConsumer;
import net.minecraft.client.StringSplitter;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.TextHandlerExt;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={StringSplitter.class})
public class TextHandlerMixin
implements TextHandlerExt {
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Unique
    private CaxtonTextHandler caxtonTextHandler;

    @Override
    public CaxtonTextHandler getCaxtonTextHandler() {
        return this.caxtonTextHandler;
    }

    @Override
    public void setCaxtonTextHandler(CaxtonTextHandler handler) {
        this.caxtonTextHandler = handler;
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/client/StringSplitter$WidthProvider;)V"})
    private void onInit(StringSplitter.WidthProvider widthRetriever, CallbackInfo ci) {
        this.setCaxtonTextHandler(new CaxtonTextHandler(CaxtonTextHandler.EMPTY_FONT_STORAGE_ACCESSOR, (StringSplitter)this));
    }

    @Inject(at={@At(value="HEAD")}, method={"stringWidth(Ljava/lang/String;)F"}, cancellable=true)
    private void onGetWidth(String text, CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(this.caxtonTextHandler.getWidth(text)));
    }

    @Inject(at={@At(value="HEAD")}, method={"stringWidth(Lnet/minecraft/network/chat/FormattedText;)F"}, cancellable=true)
    private void onGetWidth(FormattedText text, CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(this.caxtonTextHandler.getWidth(text)));
    }

    @Inject(at={@At(value="HEAD")}, method={"stringWidth(Lnet/minecraft/util/FormattedCharSequence;)F"}, cancellable=true)
    private void onGetWidth(FormattedCharSequence text, CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(this.caxtonTextHandler.getWidth(text)));
    }

    @Inject(at={@At(value="HEAD")}, method={"plainIndexAtWidth(Ljava/lang/String;ILnet/minecraft/network/chat/Style;)I"}, cancellable=true)
    private void onGetTrimmedLength(String text, int maxWidth, Style style, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.getCharIndexAtX(text, maxWidth, style));
    }

    @Inject(at={@At(value="HEAD")}, method={"plainHeadByWidth(Ljava/lang/String;ILnet/minecraft/network/chat/Style;)Ljava/lang/String;"})
    private void onTrimToWidth(String text, int maxWidth, Style style, CallbackInfoReturnable<String> cir) {
        CaxtonModClient.onBrokenMethod();
    }

    @Inject(at={@At(value="HEAD")}, method={"plainTailByWidth(Ljava/lang/String;ILnet/minecraft/network/chat/Style;)Ljava/lang/String;"})
    private void onTrimToWidthBackwards(String text, int maxWidth, Style style, CallbackInfoReturnable<String> cir) {
        CaxtonModClient.onBrokenMethod();
    }

    @Inject(at={@At(value="HEAD")}, method={"formattedIndexByWidth(Ljava/lang/String;ILnet/minecraft/network/chat/Style;)I"}, cancellable=true)
    private void onGetLimitedStringLength(String text, int maxWidth, Style style, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.getCharIndexAtXFormatted(text, maxWidth, style));
    }

    @Inject(at={@At(value="HEAD")}, method={"formattedHeadByWidth(Ljava/lang/String;ILnet/minecraft/network/chat/Style;)Ljava/lang/String;"})
    private void onLimitString(String text, int maxWidth, Style style, CallbackInfoReturnable<String> cir) {
        CaxtonModClient.onBrokenMethod();
    }

    @Inject(at={@At(value="HEAD")}, method={"headByWidth(Lnet/minecraft/network/chat/FormattedText;ILnet/minecraft/network/chat/Style;)Lnet/minecraft/network/chat/FormattedText;"}, cancellable=true)
    private void onTrimToWidth(FormattedText text, int width, Style style, CallbackInfoReturnable<FormattedText> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.trimToWidth(text, width, style));
    }

    @Inject(at={@At(value="HEAD")}, method={"componentStyleAtWidth(Lnet/minecraft/network/chat/FormattedText;I)Lnet/minecraft/network/chat/Style;"}, cancellable=true)
    private void onGetStyleAt(FormattedText text, int x, CallbackInfoReturnable<Style> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.getStyleAt(text, x));
    }

    @Inject(at={@At(value="HEAD")}, method={"componentStyleAtWidth(Lnet/minecraft/util/FormattedCharSequence;I)Lnet/minecraft/network/chat/Style;"}, cancellable=true)
    private void onGetStyleAt(FormattedCharSequence text, int x, CallbackInfoReturnable<Style> cir) {
        cir.setReturnValue((Object)this.caxtonTextHandler.getStyleAt(text, x));
    }

    @Inject(at={@At(value="HEAD")}, method={"splitLines(Lnet/minecraft/network/chat/FormattedText;ILnet/minecraft/network/chat/Style;Ljava/util/function/BiConsumer;)V"}, cancellable=true)
    private void onWrapLines(FormattedText text, int maxWidth, Style style, BiConsumer<FormattedText, Boolean> lineConsumer, CallbackInfo ci) {
        this.caxtonTextHandler.wrapLines(text, maxWidth, style, lineConsumer);
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"splitLines(Ljava/lang/String;ILnet/minecraft/network/chat/Style;ZLnet/minecraft/client/StringSplitter$LinePosConsumer;)V"}, cancellable=true)
    private void onWrapLines(String text, int maxWidth, Style style, boolean retainTrailingWordSplit, StringSplitter.LinePosConsumer consumer, CallbackInfo ci) {
        this.caxtonTextHandler.wrapLines(text, maxWidth, style, retainTrailingWordSplit, consumer);
        ci.cancel();
    }
}

