/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.render.CaxtonGlyphCache;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Font.class})
public abstract class TextRendererMixin
implements HasCaxtonTextRenderer {
    @Shadow
    @Final
    private StringSplitter splitter;
    @Unique
    private static final Supplier<CaxtonGlyphCache> CACHE = Suppliers.memoize(() -> new CaxtonGlyphCache(Minecraft.getInstance().getTextureManager()));
    @Unique
    private CaxtonTextRenderer caxtonRenderer;

    @Shadow
    public abstract boolean isBidirectional();

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/client/gui/Font$Provider;)V"})
    private void onInit(Font.Provider fonts, CallbackInfo ci) {
        this.caxtonRenderer = new CaxtonTextRenderer((Font)this, this.splitter, CACHE);
    }

    @Inject(method={"bidirectionalShaping(Ljava/lang/String;)Ljava/lang/String;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMirror(String text, CallbackInfoReturnable<String> cir) {
        this.caxtonRenderer.rtl = true;
        cir.setReturnValue((Object)text);
    }

    @Inject(at={@At(value="HEAD")}, method={"drawInBatch8xOutline(Lnet/minecraft/util/FormattedCharSequence;FFIILorg/joml/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, cancellable=true)
    private void onDrawWithOutline(FormattedCharSequence text, float x, float y, int color, int outlineColor, Matrix4f matrix, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        this.caxtonRenderer.drawWithOutline(text, x, y, color, outlineColor, matrix, vertexConsumers, light, true);
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"prepareText(Ljava/lang/String;FFIZI)Lnet/minecraft/client/gui/Font$PreparedText;"}, cancellable=true)
    private void onPrepareString(String text, float x, float y, int color, boolean shadow, int backgroundColor, CallbackInfoReturnable<Font.PreparedText> cir) {
        cir.setReturnValue((Object)this.caxtonRenderer.prepare(CaxtonText.fromFormatted(text, this.caxtonRenderer.getFontStorageAccessor(), Style.EMPTY, this.caxtonRenderer.validatesAdvance(), this.isBidirectional(), this.caxtonRenderer.getHandler().getCache()), x, y, color, shadow, backgroundColor, -1, Float.POSITIVE_INFINITY));
    }

    @Inject(at={@At(value="HEAD")}, method={"prepareText(Lnet/minecraft/util/FormattedCharSequence;FFIZI)Lnet/minecraft/client/gui/Font$PreparedText;"}, cancellable=true)
    private void onPrepareOrderedText(FormattedCharSequence text, float x, float y, int color, boolean shadow, int backgroundColor, CallbackInfoReturnable<Font.PreparedText> cir) {
        cir.setReturnValue((Object)this.caxtonRenderer.prepare(CaxtonText.from(text, this.caxtonRenderer.getFontStorageAccessor(), this.caxtonRenderer.validatesAdvance(), this.isBidirectional(), this.caxtonRenderer.getHandler().getCache()), x, y, color, shadow, backgroundColor, -1, Float.POSITIVE_INFINITY));
    }

    @Override
    public CaxtonTextRenderer getCaxtonTextRenderer() {
        return this.caxtonRenderer;
    }
}

