/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin.gui;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.DirectionSetting;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;
import xyz.flirora.caxton.render.Voepfxo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractSignEditScreen.class})
public abstract class AbstractSignEditScreenMixin
extends Screen {
    @Shadow
    @Final
    private SignBlockEntity sign;
    @Shadow
    @Final
    private String[] messages;
    @Shadow
    private TextFieldHelper signField;
    @Shadow
    private int line;
    @Unique
    private CaxtonText rowText;
    @Unique
    private CaxtonText currentRowText;

    protected AbstractSignEditScreenMixin(Component title) {
        super(title);
    }

    @Redirect(method={"renderSignText(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)V", ordinal=0))
    private void drawRowTextProxy(GuiGraphics instance, Font textRenderer, String currentLine, int x, int y, int color, boolean shadow) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)textRenderer).getCaxtonTextRenderer();
        CaxtonTextHandler cth = ctr.getHandler();
        this.rowText = CaxtonText.fromFormatted(currentLine, ctr.getFontStorageAccessor(), Style.EMPTY, false, this.font.isBidirectional(), cth.getCache());
        if (currentLine == this.messages[this.line]) {
            this.currentRowText = this.rowText;
        }
        Voepfxo.drawText(instance, textRenderer, this.rowText, -cth.getWidth(this.rowText) / 2.0f, (float)y, color, false);
    }

    @Redirect(method={"renderSignText(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)V", ordinal=1))
    private void drawEndCursorProxy(GuiGraphics instance, Font textRenderer, String text, int x, int y, int color, boolean shadow) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)textRenderer).getCaxtonTextRenderer();
        CaxtonTextHandler cth = ctr.getHandler();
        Voepfxo.drawText(instance, textRenderer, "_", cth.getWidth(this.rowText) / 2.0f, y, color);
    }

    @Redirect(method={"renderSignText(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=0))
    private void drawVerticalCursor(GuiGraphics instance, int x1, int y1, int x2, int y2, int color) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.font).getCaxtonTextRenderer();
        CaxtonTextHandler cth = ctr.getHandler();
        String currentLine = this.messages[this.line];
        int selectionStart = this.signField.getCursorPos();
        int yAdj = 4 * this.sign.getTextLineHeight() / 2;
        int lineY = this.line * this.sign.getTextLineHeight() - yAdj;
        float x = cth.getWidth(this.currentRowText) / 2.0f;
        float cursorOffset = cth.getOffsetAtIndex(this.currentRowText, Math.min(selectionStart, currentLine.length()), DirectionSetting.AUTO);
        float cursorX = cursorOffset - x;
        Voepfxo.fill(instance, cursorX, lineY - 1, cursorX + 1.0f, lineY + this.sign.getTextLineHeight(), 0xFF000000 | color);
    }

    @Redirect(method={"renderSignText(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;textHighlight(IIII)V"))
    private void drawHighlights(GuiGraphics context, int x1, int y1, int x2, int y2) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.font).getCaxtonTextRenderer();
        CaxtonTextHandler cth = ctr.getHandler();
        int selectionStart = this.signField.getCursorPos();
        int selectionEnd = this.signField.getSelectionPos();
        float x = cth.getWidth(this.currentRowText) / 2.0f;
        int yAdj = 4 * this.sign.getTextLineHeight() / 2;
        int lineY = this.line * this.sign.getTextLineHeight() - yAdj;
        cth.getHighlightRanges(this.currentRowText, Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd), (start, end) -> Voepfxo.drawSelection(context, start - x, lineY, end - x, lineY + this.sign.getTextLineHeight()));
    }
}

