/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin.gui;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.network.chat.Style;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.DirectionSetting;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;

@Mixin(value={MultilineTextField.class})
public abstract class EditBoxMixin {
    @Shadow
    private int cursor;
    @Unique
    private int ttwLength;

    @Shadow
    protected abstract MultilineTextField.StringView getCursorLineView();

    @ModifyArg(method={"seekCursorLine(I)V"}, at=@At(value="INVOKE", target="Ljava/lang/String;substring(II)Ljava/lang/String;", ordinal=0), index=1)
    private int forceEntireLine(int cursor) {
        return this.getCursorLineView().endIndex();
    }

    @Redirect(method={"seekCursorLine(I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;width(Ljava/lang/String;)I", ordinal=0))
    private int redirectGetWidth(Font textRenderer, String text) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)textRenderer).getCaxtonTextRenderer();
        CaxtonText caxtonText = CaxtonText.fromForwards(text, ctr.getFontStorageAccessor(), Style.EMPTY, false, false, ctr.getHandler().getCache());
        return Math.round(ctr.getHandler().getOffsetAtIndex(caxtonText, this.cursor - this.getCursorLineView().beginIndex(), DirectionSetting.AUTO));
    }

    @Redirect(method={"seekCursorLine(I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;plainSubstrByWidth(Ljava/lang/String;I)Ljava/lang/String;"))
    private String redirectTrimToWidthL(Font textRenderer, String text, int maxWidth) {
        this.ttwLength = textRenderer.getSplitter().plainIndexAtWidth(text, maxWidth, Style.EMPTY);
        return null;
    }

    @Redirect(method={"seekCursorLine(I)V"}, at=@At(value="INVOKE", target="Ljava/lang/String;length()I"))
    private int redirectTrimmedStringLengthL(String s) {
        return this.ttwLength;
    }

    @Redirect(method={"seekCursorToPoint(DD)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;plainSubstrByWidth(Ljava/lang/String;I)Ljava/lang/String;"))
    private String redirectTrimToWidthXy(Font textRenderer, String text, int maxWidth) {
        this.ttwLength = textRenderer.getSplitter().plainIndexAtWidth(text, maxWidth, Style.EMPTY);
        return null;
    }

    @Redirect(method={"seekCursorToPoint(DD)V"}, at=@At(value="INVOKE", target="Ljava/lang/String;length()I"))
    private int redirectTrimmedStringLengthXy(String s) {
        return this.ttwLength;
    }
}

