/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin.gui;

import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractTextAreaWidget;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.DirectionSetting;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;
import xyz.flirora.caxton.render.Voepfxo;

@Mixin(value={MultiLineEditBox.class})
public abstract class EditBoxWidgetMixin
extends AbstractTextAreaWidget {
    @Shadow
    @Final
    private static String CURSOR_APPEND_CHARACTER;
    @Shadow
    @Final
    private MultilineTextField textField;
    @Shadow
    @Final
    private Font font;
    @Shadow
    @Final
    private Component placeholder;
    @Shadow
    private long focusedTime;
    @Shadow
    @Final
    private int textColor;
    @Shadow
    @Final
    private boolean textShadow;
    @Shadow
    @Final
    private int cursorColor;

    public EditBoxWidgetMixin(int i, int j, int k, int l, Component text) {
        super(i, j, k, l, text);
    }

    @Inject(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/MultilineTextField;cursor()I")}, cancellable=true)
    private void onRenderContents(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.font).getCaxtonTextRenderer();
        CaxtonTextHandler cth = ctr.getHandler();
        String text = this.textField.value();
        int cursorPos = this.textField.cursor();
        boolean drawCursor = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L;
        boolean cursorVertical = cursorPos < text.length();
        float cursorX = 0.0f;
        int endY = 0;
        int y = this.getInnerTop();
        for (MultilineTextField.StringView line : this.textField.iterateLines()) {
            Objects.requireNonNull(this.font);
            boolean lineVisible = this.withinContentAreaTopBottom(y, y + 9);
            String lineStr = text.substring(line.beginIndex(), line.endIndex());
            int textX = this.getInnerLeft();
            if (drawCursor && cursorVertical && cursorPos >= line.beginIndex() && cursorPos <= line.endIndex()) {
                if (lineVisible) {
                    Voepfxo.drawText(context, this.font, lineStr, (float)textX, (float)y, this.textColor, this.textShadow);
                    cursorX = (float)textX + cth.getOffsetAtIndex(CaxtonText.fromForwards(lineStr, ctr.getFontStorageAccessor(), Style.EMPTY, false, false, cth.getCache()), cursorPos - line.beginIndex(), DirectionSetting.AUTO);
                    float f = y - 1;
                    Objects.requireNonNull(this.font);
                    Voepfxo.fill(context, cursorX, f, cursorX + 1.0f, y + 1 + 9, this.cursorColor);
                }
            } else {
                if (lineVisible) {
                    Voepfxo.drawText(context, this.font, lineStr, (float)textX, (float)y, this.textColor, this.textShadow);
                    cursorX = (float)textX + cth.getWidth(lineStr);
                }
                endY = y;
            }
            Objects.requireNonNull(this.font);
            y += 9;
        }
        if (drawCursor && !cursorVertical) {
            Objects.requireNonNull(this.font);
            if (this.withinContentAreaTopBottom(endY, endY + 9)) {
                Voepfxo.drawText(context, this.font, CURSOR_APPEND_CHARACTER, cursorX, (float)endY, this.cursorColor, this.textShadow);
            }
        }
        if (this.textField.hasSelection()) {
            MultilineTextField.StringView selection = this.textField.getSelected();
            int selX = this.getInnerLeft();
            y = this.getInnerTop();
            for (MultilineTextField.StringView line : this.textField.iterateLines()) {
                if (selection.beginIndex() > line.endIndex()) {
                    Objects.requireNonNull(this.font);
                    y += 9;
                    continue;
                }
                if (line.beginIndex() > selection.endIndex()) break;
                Objects.requireNonNull(this.font);
                if (this.withinContentAreaTopBottom(y, y + 9)) {
                    float selY = y;
                    CaxtonText caxtonLine = CaxtonText.fromForwards(text.substring(line.beginIndex(), line.endIndex()), ctr.getFontStorageAccessor(), Style.EMPTY, false, false, cth.getCache());
                    cth.getHighlightRanges(caxtonLine, Math.max(0, selection.beginIndex() - line.beginIndex()), Math.min(selection.endIndex(), line.endIndex()) - line.beginIndex(), (left, right) -> {
                        float f = (float)selX + left;
                        float f2 = (float)selX + right;
                        Objects.requireNonNull(this.font);
                        Voepfxo.drawSelection(context, f, selY, f2, selY + 9.0f);
                    });
                }
                Objects.requireNonNull(this.font);
                y += 9;
            }
        }
        ci.cancel();
    }
}

