/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.mixin.gui;

import com.llamalad7.mixinextras.injector.ModifyReceiver;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.DirectionSetting;
import xyz.flirora.caxton.layout.gui.TextFieldWidgetExt;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;
import xyz.flirora.caxton.render.Voepfxo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={EditBox.class})
public abstract class TextFieldWidgetMixin
extends AbstractWidget
implements Renderable,
GuiEventListener,
TextFieldWidgetExt {
    private static final Style SUGGESTION = Style.EMPTY.withColor(-8355712);
    @Unique
    private static final Matrix4f IDENTITY = new Matrix4f();
    @Shadow
    @Final
    private static String CURSOR_APPEND_CHARACTER;
    @Shadow
    @Final
    private Font font;
    @Shadow
    private String value;
    @Shadow
    private boolean isEditable;
    @Shadow
    private int textColor;
    @Shadow
    private int textColorUneditable;
    @Shadow
    private boolean bordered;
    @Shadow
    private int displayPos;
    @Unique
    private CaxtonText caxtonText;
    @Shadow
    private int cursorPos;
    @Shadow
    private int highlightPos;
    @Shadow
    @Nullable
    private String suggestion;
    @Shadow
    @Nullable
    private Component hint;
    @Shadow
    @Nullable
    private Consumer<String> responder;
    @Unique
    private boolean updatingCaxtonText = false;
    @Shadow
    private long focusedTime;
    @Shadow
    private int textX;
    @Shadow
    private int textY;
    @Shadow
    private boolean textShadow;

    public TextFieldWidgetMixin(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Shadow
    public abstract int getInnerWidth();

    @Shadow
    protected abstract int getMaxLength();

    @Shadow
    public abstract void moveCursorTo(int var1, boolean var2);

    @Shadow
    public abstract void setCursorPosition(int var1);

    @Shadow
    protected abstract boolean isCentered();

    @Shadow
    protected abstract void updateTextPosition();

    @Shadow
    protected abstract FormattedCharSequence applyFormat(String var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCaxtonText(boolean changed) {
        if (this.updatingCaxtonText) {
            return;
        }
        this.updatingCaxtonText = true;
        if (changed && this.responder != null) {
            this.responder.accept(this.value);
        }
        try {
            FormattedCharSequence text;
            boolean hideSuggestion = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
            FormattedCharSequence formattedCharSequence = text = this.value.isEmpty() ? FormattedCharSequence.EMPTY : this.applyFormat(this.value, 0);
            if (!hideSuggestion && this.suggestion != null) {
                text = FormattedCharSequence.composite((FormattedCharSequence)text, (FormattedCharSequence)FormattedCharSequence.forward((String)this.suggestion, (Style)SUGGESTION));
            }
            if (this.font == null) {
                return;
            }
            CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.font).getCaxtonTextRenderer();
            this.caxtonText = CaxtonText.from(text, ctr.getFontStorageAccessor(), true, false, ctr.getHandler().getCache());
        }
        finally {
            this.updatingCaxtonText = false;
            this.updateTextPosition();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onValueChange(Ljava/lang/String;)V"}, cancellable=true)
    private void stubOnChanged(String newText, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/gui/components/EditBox;value:Ljava/lang/String;", opcode=181, shift=At.Shift.AFTER)}, method={"setValue(Ljava/lang/String;)V"})
    private void updateCaxtonTextOnSetText(String text, CallbackInfo ci) {
        this.highlightPos = this.cursorPos = text.length();
        this.updateCaxtonText(true);
    }

    @ModifyReceiver(method={"insertText(Ljava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;setCursorPosition(I)V")})
    private EditBox updateCaxtonTextOnWrite(EditBox me, int newSelectionStart) {
        this.setCursorPosition(newSelectionStart);
        this.highlightPos = this.cursorPos;
        this.updateCaxtonText(true);
        return me;
    }

    @Inject(method={"moveCursorTo(IZ)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;onValueChange(Ljava/lang/String;)V")})
    private void onSetCursor(int cursor, boolean shiftKeyPressed, CallbackInfo ci) {
        this.updateCaxtonText(false);
    }

    @ModifyReceiver(method={"deleteCharsToPos(I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;moveCursorTo(IZ)V")})
    private EditBox updateCaxtonTextOnEraseCharacters(EditBox me, int cursor, boolean shiftKeyPressed) {
        this.setCursorPosition(cursor);
        this.highlightPos = this.cursorPos;
        this.updateCaxtonText(true);
        return me;
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/gui/components/EditBox;value:Ljava/lang/String;", opcode=181, shift=At.Shift.AFTER)}, method={"setMaxLength(I)V"})
    private void updateCaxtonTextOnSetMaxLength(int maxLength, CallbackInfo ci) {
        this.cursorPos = Math.min(this.cursorPos, this.value.length());
        this.highlightPos = Math.min(this.highlightPos, this.value.length());
        this.updateCaxtonText(true);
    }

    @Inject(at={@At(value="TAIL")}, method={"setSuggestion(Ljava/lang/String;)V"})
    private void updateCaxtonTextOnSuggestionSet(String text, CallbackInfo ci) {
        this.updateCaxtonText(false);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;getInnerWidth()I")}, method={"renderWidget(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, cancellable=true)
    private void onRenderButton(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.font).getCaxtonTextRenderer();
        int color = this.isEditable ? this.textColor : this.textColorUneditable;
        int x = this.textX;
        int y = this.textY;
        float firstCharLocation = 0.0f;
        float selectionStartLocation = 0.0f;
        if (this.caxtonText != null) {
            Voepfxo.drawText(context, this.font, this.caxtonText, x, y, color, this.textShadow, this.displayPos, this.getInnerWidth());
            firstCharLocation = ctr.getHandler().getOffsetAtIndex(this.caxtonText, this.displayPos, DirectionSetting.FORCE_LTR);
            selectionStartLocation = ctr.getHandler().getOffsetAtIndex(this.caxtonText, this.cursorPos, DirectionSetting.AUTO);
        }
        boolean cursorIsVertical = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
        float cursorLocation = selectionStartLocation - firstCharLocation;
        boolean cursorInBounds = 0.0f <= cursorLocation && cursorLocation < (float)this.getInnerWidth();
        boolean showCursor = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L && cursorInBounds;
        float cursorX = Math.round((float)x + cursorLocation);
        if (!cursorInBounds) {
            float f = cursorX = cursorLocation > 0.0f ? (float)(x + this.width) : (float)x;
        }
        if (this.hint != null && this.value.isEmpty() && !this.isFocused()) {
            Voepfxo.drawTextWithShadow(context, this.font, this.hint, cursorX, (float)y, color);
        }
        if (showCursor) {
            if (cursorIsVertical) {
                float f = y - 1;
                Objects.requireNonNull(this.font);
                Voepfxo.fill(context, cursorX, f, cursorX + 1.0f, y + 1 + 9, -3092272);
            } else {
                Voepfxo.drawText(context, this.font, CURSOR_APPEND_CHARACTER, cursorX, (float)y, color, this.textShadow);
            }
        }
        if (this.cursorPos != this.highlightPos) {
            float finalFirstCharLocation = firstCharLocation;
            ctr.getHandler().getHighlightRanges(this.caxtonText, Math.min(this.cursorPos, this.highlightPos), Math.max(this.cursorPos, this.highlightPos), (x0, x1) -> {
                float f = (float)x + x0 - finalFirstCharLocation;
                float f2 = y - 1;
                float f3 = (float)x + x1 - finalFirstCharLocation;
                Objects.requireNonNull(this.font);
                this.myDrawSelectionHighlight(context, f, f2, f3, y + 1 + 9);
            });
        }
        ci.cancel();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;getInnerWidth()I")}, method={"findClickedPositionInText(Lnet/minecraft/client/input/MouseButtonEvent;)I"}, cancellable=true)
    private void overrideCursorPosition(MouseButtonEvent click, CallbackInfoReturnable<Integer> cir) {
        if (this.caxtonText == null) {
            this.updateCaxtonText(false);
        }
        CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.font).getCaxtonTextRenderer();
        float xOffset = Math.min((float)(click.x() - (double)this.textX), (float)this.getInnerWidth());
        int index = ctr.getHandler().getCharIndexAtX(this.caxtonText, xOffset, this.displayPos);
        cir.setReturnValue((Object)index);
    }

    @Inject(at={@At(value="HEAD")}, method={"scrollTo(I)V"}, cancellable=true)
    private void onUpdateFirstCharacterIndex(int cursor, CallbackInfo ci) {
        int length = this.value.length();
        if (this.font != null && this.caxtonText != null) {
            if (this.displayPos > length) {
                this.displayPos = length;
            }
            int width = this.getInnerWidth();
            CaxtonTextRenderer ctr = ((HasCaxtonTextRenderer)this.font).getCaxtonTextRenderer();
            float firstCharLocation = ctr.getHandler().getOffsetAtIndex(this.caxtonText, this.displayPos, DirectionSetting.FORCE_LTR);
            float cursorLocation = ctr.getHandler().getOffsetAtIndex(this.caxtonText, cursor, DirectionSetting.AUTO);
            if (cursor == this.displayPos) {
                this.displayPos = ctr.getHandler().getCharIndexAtX(this.caxtonText, cursorLocation - (float)width, -1);
            } else if (cursorLocation < firstCharLocation) {
                this.displayPos = ctr.getHandler().getCharIndexAtX(this.caxtonText, Math.min(firstCharLocation - (float)width, cursorLocation), -1);
            } else if (cursorLocation >= firstCharLocation + (float)width) {
                this.displayPos = ctr.getHandler().getCharIndexAfterX(this.caxtonText, cursorLocation - (float)width, -1);
            }
            this.displayPos = Mth.clamp((int)this.displayPos, (int)0, (int)length);
        }
        ci.cancel();
    }

    @Inject(method={"updateTextPosition()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateTextPosition(CallbackInfo ci) {
        if (this.font != null) {
            if (this.isCentered()) {
                if (this.caxtonText == null) {
                    this.textX = this.getX() + this.getWidth() / 2;
                } else {
                    CaxtonTextHandler handler = ((HasCaxtonTextRenderer)this.font).getCaxtonTextRenderer().getHandler();
                    int i = handler.getCharIndexAtX(this.caxtonText, this.getInnerWidth(), this.displayPos, true);
                    this.textX = Math.round((float)this.getX() + ((float)this.getWidth() - handler.getOffsetAtIndex(this.caxtonText, i, DirectionSetting.FORCE_LTR)) / 2.0f);
                }
            } else {
                this.textX = this.getX() + (this.bordered ? 4 : 0);
            }
            this.textY = this.bordered ? this.getY() + (this.height - 8) / 2 : this.getY();
        }
        ci.cancel();
    }

    @Unique
    private void myDrawSelectionHighlight(GuiGraphics context, float x1, float y1, float x2, float y2) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        if (x2 > (float)(this.getX() + this.width)) {
            x2 = this.getX() + this.width;
        }
        if (x1 > (float)(this.getX() + this.width)) {
            x1 = this.getX() + this.width;
        }
        if (x2 < (float)this.getX()) {
            x2 = this.getX();
        }
        if (x1 < (float)this.getX()) {
            x1 = this.getX();
        }
        Voepfxo.drawSelection(context, x1, y1, x2, y2);
    }
}

