/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.font.GlyphInfo;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GlyphSource;
import net.minecraft.client.gui.font.TextRenderable;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EffectGlyph;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingResult;
import xyz.flirora.caxton.layout.Threshold;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonGlyphCache;
import xyz.flirora.caxton.render.CaxtonTextRenderLayers;
import xyz.flirora.caxton.render.CaxtonTextRenderer;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonTextDrawer
implements FormattedCharSink,
Font.PreparedText {
    private final CaxtonTextRenderer textRenderer;
    private final boolean shadow;
    private final int color;
    private final int backgroundColor;
    private float x;
    private float y;
    private final List<TextRenderable> glyphs;
    @Nullable
    private List<TextRenderable> rectangles;
    private final float xRight;
    private final Threshold threshold;
    private final RandomSource random = RandomSource.createNewThreadLocalInstance();
    private boolean outline = false;
    private float minX = Float.MAX_VALUE;
    private float minY = Float.MAX_VALUE;
    private float maxX = Float.MIN_VALUE;
    private float maxY = Float.MIN_VALUE;
    private float minBackgroundX = Float.MAX_VALUE;
    private float minBackgroundY = Float.MAX_VALUE;
    private float maxBackgroundX = Float.MIN_VALUE;
    private float maxBackgroundY = Float.MIN_VALUE;
    private static final float FOREGROUND_Z_INDEX = 0.001f;
    private static final float BACKGROUND_Z_INDEX = -0.001f;

    public CaxtonTextDrawer(CaxtonTextRenderer textRenderer, float x, float y, int color, int backgroundColor, boolean shadow, float xRight, Threshold threshold) {
        this.textRenderer = textRenderer;
        this.shadow = shadow;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.x = x;
        this.y = y;
        this.glyphs = new ArrayList<TextRenderable>();
        this.xRight = xRight;
        this.threshold = threshold;
    }

    public CaxtonTextDrawer(CaxtonTextRenderer textRenderer, float x, float y, int color, boolean shadow, float xRight, Threshold threshold) {
        this(textRenderer, x, y, color, 0, shadow, xRight, threshold);
    }

    public CaxtonTextDrawer outlined() {
        this.outline = true;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    private void updateTextBounds(float minX, float minY, float maxX, float maxY) {
        this.minX = Math.min(this.minX, minX);
        this.minY = Math.min(this.minY, minY);
        this.maxX = Math.max(this.maxX, maxX);
        this.maxY = Math.max(this.maxY, maxY);
    }

    private void updateBackgroundBounds(float x, float y, float width) {
        if (ARGB.alpha((int)this.backgroundColor) != 0) {
            this.minBackgroundX = Math.min(this.minBackgroundX, x - 1.0f);
            this.minBackgroundY = Math.min(this.minBackgroundY, y - 1.0f);
            this.maxBackgroundX = Math.max(this.maxBackgroundX, x + width);
            this.maxBackgroundY = Math.max(this.maxBackgroundY, y + 9.0f);
            this.updateTextBounds(this.minBackgroundX, this.minBackgroundY, this.maxBackgroundX, this.maxBackgroundY);
        }
    }

    private void addGlyph(TextRenderable glyph) {
        this.glyphs.add(glyph);
        this.updateTextBounds(glyph.left(), glyph.top(), glyph.right(), glyph.bottom());
    }

    public void addRectangle(TextRenderable rectangle) {
        if (this.rectangles == null) {
            this.rectangles = new ArrayList<TextRenderable>();
        }
        this.rectangles.add(rectangle);
        this.updateTextBounds(rectangle.left(), rectangle.top(), rectangle.right(), rectangle.bottom());
    }

    public boolean accept(int index, Style style, int codePoint) {
        if (this.x >= this.xRight) {
            return false;
        }
        GlyphSource glyphProvider = this.textRenderer.getGlyphs(style.getFont());
        BakedGlyph glyph = glyphProvider.getGlyph(codePoint);
        return this.accept(index, style, glyph);
    }

    public boolean accept(int index, Style style, BakedGlyph glyph) {
        float shadowOffset;
        GlyphInfo glyphMetrics = glyph.info();
        boolean bold = style.isBold();
        TextColor textColor = style.getColor();
        int renderColor = this.getRenderColor(textColor);
        int shadowColor = this.getShadowColor(style, renderColor);
        float advance = glyphMetrics.getAdvance(bold);
        float x = index == 0 ? this.x - 1.0f : this.x;
        float boldOffset = bold ? glyphMetrics.getBoldOffset() : 0.0f;
        TextRenderable drawable = glyph.createGlyph(this.x, this.y, renderColor, shadowColor, style, boldOffset, shadowOffset = glyphMetrics.getShadowOffset());
        if (drawable != null) {
            this.addGlyph(drawable);
        }
        this.updateBackgroundBounds(this.x, this.y, advance);
        EffectGlyph rectangle = this.textRenderer.getFonts().effect();
        if (style.isStrikethrough()) {
            this.addRectangle(rectangle.createEffect(x + shadowOffset, this.y + shadowOffset + 3.5f, this.x + shadowOffset + advance, this.y + shadowOffset + 4.5f, 0.001f, renderColor, shadowColor, shadowOffset));
        }
        if (style.isUnderlined()) {
            this.addRectangle(rectangle.createEffect(x + shadowOffset, this.y + shadowOffset + 8.0f, this.x + shadowOffset + advance, this.y + shadowOffset + 9.0f, 0.001f, renderColor, shadowColor, shadowOffset));
        }
        this.x += advance;
        this.threshold.updateLegacy(index);
        return true;
    }

    public boolean acceptShapedRun(ShapingResult shapedRun, RunGroup runGroup, int index, CaxtonGlyphCache cache, int glyphOffset, float minThickness, CaxtonTextRenderLayers renderLayers) {
        if (this.x >= this.xRight) {
            return false;
        }
        float origX = this.x;
        ConfiguredCaxtonFont configuredFont = runGroup.getFont();
        CaxtonFont font = configuredFont.font();
        CaxtonGlyphCache.Font cacheForFont = cache.forFont(font);
        EffectGlyph rectangle = this.textRenderer.getFonts().effect();
        assert (glyphOffset + font.getGlyphCount() <= font.getTlistSize());
        float shadowOffset = configuredFont.shadowOffset();
        float textZ = this.shadow ? 0.03f : 0.0f;
        int offset = runGroup.getBidiRuns()[4 * index + 0];
        short underlinePosition = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_POSITION);
        short underlineThickness = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_THICKNESS);
        short strikeoutPosition = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_POSITION);
        short strikeoutThickness = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_THICKNESS);
        float scale = configuredFont.getScale();
        float baselineY = this.y + 7.0f + configuredFont.shiftY();
        this.x += configuredFont.shiftX();
        float yu = baselineY - (float)underlinePosition * scale;
        float ys = baselineY - (float)strikeoutPosition * scale;
        float dyu = (float)underlineThickness * scale;
        float dys = (float)strikeoutThickness * scale;
        float ou = 0.5f * dyu;
        float os = 0.5f * dys;
        if (dyu < minThickness) {
            dyu = minThickness;
        }
        if (dys < minThickness) {
            dys = minThickness;
        }
        float y0u = yu + 0.5f * dyu;
        float y1u = yu - 0.5f * dyu;
        float y0s = ys + 0.5f * dys;
        float y1s = ys - 0.5f * dys;
        int numGlyphs = shapedRun.numGlyphs();
        int cumulAdvanceX = 0;
        for (int i = 0; i < numGlyphs; ++i) {
            int glyphId = shapedRun.glyphId(i);
            int clusterIndex = shapedRun.clusterIndex(i);
            if (this.threshold.updateCaxton(runGroup, index, shapedRun, i)) continue;
            Style style = runGroup.getStyleAt(offset + clusterIndex);
            if (style.isObfuscated()) {
                long tlLoc = font.getTlistLocation(glyphId, 0);
                int width = (int)(tlLoc & 0xFFFFL);
                IntList others = (IntList)font.getGlyphsByWidth().get(width);
                glyphId = others.getInt(this.random.nextInt(others.size()));
            }
            int textColor = this.getRenderColor(style.getColor());
            int shadowColor = this.getShadowColor(style, textColor);
            Style drawnStyle = style.withBold(Boolean.valueOf(false)).withItalic(Boolean.valueOf(false));
            int advanceX = shapedRun.advanceX(i);
            int offsetX = shapedRun.offsetX(i);
            int offsetY = shapedRun.offsetY(i);
            int gx = cumulAdvanceX + offsetX;
            long atlasLoc = cacheForFont.getOrCreateAtlasLocation(glyphOffset + glyphId);
            BakedGlyph bakedGlyph = cacheForFont.getBakedGlyph(glyphId, renderLayers, cache, configuredFont, this.outline);
            if (bakedGlyph != null) {
                int atlasPageIndex = CaxtonAtlas.getPage(atlasLoc);
                long glyphBbox = font.getBbox(glyphId);
                short bbXMin = (short)glyphBbox;
                short bbYMin = (short)(glyphBbox >> 16);
                float glyphX = this.x + (float)(gx += bbXMin) * scale;
                float glyphY = (float)(-(offsetY += bbYMin)) * scale + baselineY;
                this.addGlyph(bakedGlyph.createGlyph(glyphX, glyphY, textColor, shadowColor, drawnStyle, 0.0f, configuredFont.shadowOffset()));
                this.updateBackgroundBounds(glyphX, this.y, (float)advanceX * scale);
                if (glyphX + (float)advanceX * scale >= this.xRight) break;
            }
            float x0a = this.x + (float)cumulAdvanceX * scale;
            float x1a = this.x + (float)(cumulAdvanceX + advanceX) * scale;
            if (style.isUnderlined()) {
                this.addRectangle(rectangle.createEffect(x0a, y1u, x1a, y0u, 0.001f + textZ, textColor, shadowColor, shadowOffset));
            }
            if (style.isStrikethrough()) {
                this.addRectangle(rectangle.createEffect(x0a, y1s, x1a, y0s, 0.001f + textZ, textColor, shadowColor, shadowOffset));
            }
            cumulAdvanceX += advanceX;
        }
        this.x = origX + (float)cumulAdvanceX * scale - configuredFont.shiftX();
        return true;
    }

    public int getRenderColor(@Nullable TextColor override) {
        if (override != null && !this.outline) {
            int alpha = ARGB.alpha((int)this.color);
            int rgb = override.getValue();
            return ARGB.color((int)alpha, (int)rgb);
        }
        return this.color;
    }

    public int getShadowColor(Style style, int renderColor) {
        Integer shadowColor = style.getShadowColor();
        if (shadowColor != null) {
            float textAlpha = ARGB.alphaFloat((int)renderColor);
            float shadowAlpha = ARGB.alphaFloat((int)shadowColor);
            return textAlpha != 1.0f ? ARGB.color((int)ARGB.as8BitChannel((float)(textAlpha * shadowAlpha)), (int)shadowColor) : shadowColor;
        }
        return this.shadow ? ARGB.scaleRGB((int)renderColor, (float)0.25f) : 0;
    }

    public float getForegroundZIndex() {
        return 0.001f;
    }

    public void visit(Font.GlyphVisitor glyphDrawer) {
        Object bakedGlyph = null;
        if (ARGB.alpha((int)this.backgroundColor) != 0) {
            glyphDrawer.acceptEffect(this.textRenderer.getFonts().effect().createEffect(this.minBackgroundX, this.minBackgroundY, this.maxBackgroundX, this.maxBackgroundY, -0.001f, this.backgroundColor, 0, 0.0f));
        }
        for (TextRenderable drawnGlyph : this.glyphs) {
            glyphDrawer.acceptGlyph(drawnGlyph);
        }
        if (this.rectangles != null) {
            for (TextRenderable rectangle2 : this.rectangles) {
                glyphDrawer.acceptEffect(rectangle2);
            }
        }
    }

    @Nullable
    public ScreenRectangle bounds() {
        if (!(this.minX >= this.maxX) && !(this.minY >= this.maxY)) {
            int minX = Mth.floor((float)this.minX);
            int minY = Mth.floor((float)this.minY);
            int maxX = Mth.floor((float)this.maxX) + 1;
            int maxY = Mth.floor((float)this.maxY) + 1;
            return new ScreenRectangle(minX, minY, maxX - minX, maxY - minY);
        }
        return null;
    }
}

