/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.client.gui.font.GlyphRenderTypes;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import xyz.flirora.caxton.font.FontTech;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonShaders;
import xyz.flirora.caxton.render.CaxtonTextLayerType;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonTextRenderLayers {
    private final Group msdf = new Group(RenderLayerFunctions::ofText, RenderLayerFunctions::ofTextSeeThrough, RenderLayerFunctions::ofTextOffset, RenderLayerFunctions::ofTextOutline, CaxtonShaders.TEXT);
    private final Group raster = new Group(RenderLayerFunctions::ofTextR, RenderLayerFunctions::ofTextSeeThroughR, RenderLayerFunctions::ofTextOffsetR, RenderLayerFunctions::ofTextR, RenderPipelines.TEXT_INTENSITY);

    public void clear() {
        this.msdf.clear();
        this.raster.clear();
    }

    public RenderType text(CaxtonAtlas.Page page, CaxtonTextLayerType layerType, FontTech tech) {
        return switch (tech) {
            default -> throw new MatchException(null, null);
            case FontTech.MSDF -> this.msdf.text(page, layerType);
            case FontTech.RASTER -> this.raster.text(page, layerType);
        };
    }

    public GlyphRenderTypes renderLayerSet(CaxtonAtlas.Page page, FontTech tech, boolean outline) {
        return switch (tech) {
            default -> throw new MatchException(null, null);
            case FontTech.MSDF -> this.msdf.renderLayerSet(page, outline);
            case FontTech.RASTER -> this.raster.renderLayerSet(page, outline);
        };
    }

    public static class Group {
        private final ConcurrentHashMap<CaxtonAtlas.Page, RenderType> text = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, RenderType> textSeeThrough = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, RenderType> textOffset = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, RenderType> textOutline = new ConcurrentHashMap();
        private final Function<CaxtonAtlas.Page, RenderType> ofText;
        private final Function<CaxtonAtlas.Page, RenderType> ofTextSeeThrough;
        private final Function<CaxtonAtlas.Page, RenderType> ofTextOffset;
        private final Function<CaxtonAtlas.Page, RenderType> ofTextOutline;
        private final RenderPipeline pipeline;

        public Group(Function<CaxtonAtlas.Page, RenderType> ofText, Function<CaxtonAtlas.Page, RenderType> ofTextSeeThrough, Function<CaxtonAtlas.Page, RenderType> ofTextOffset, Function<CaxtonAtlas.Page, RenderType> ofTextOutline, RenderPipeline pipeline) {
            this.ofText = ofText;
            this.ofTextSeeThrough = ofTextSeeThrough;
            this.ofTextOffset = ofTextOffset;
            this.ofTextOutline = ofTextOutline;
            this.pipeline = pipeline;
        }

        public void clear() {
            this.text.clear();
            this.textSeeThrough.clear();
            this.textOffset.clear();
            this.textOutline.clear();
        }

        public RenderType text(CaxtonAtlas.Page page, CaxtonTextLayerType layerType) {
            return switch (layerType) {
                default -> throw new MatchException(null, null);
                case CaxtonTextLayerType.NORMAL -> this.text.computeIfAbsent(page, this.ofText);
                case CaxtonTextLayerType.SEE_THROUGH -> this.textSeeThrough.computeIfAbsent(page, this.ofTextSeeThrough);
                case CaxtonTextLayerType.OUTLINE -> this.textOutline.computeIfAbsent(page, this.ofTextOutline);
                case CaxtonTextLayerType.POLYGON_OFFSET -> this.textOffset.computeIfAbsent(page, this.ofTextOffset);
            };
        }

        public GlyphRenderTypes renderLayerSet(CaxtonAtlas.Page page, boolean outline) {
            if (outline) {
                return new GlyphRenderTypes(this.textOutline.computeIfAbsent(page, this.ofTextOutline), this.textSeeThrough.computeIfAbsent(page, this.ofTextSeeThrough), this.textOffset.computeIfAbsent(page, this.ofTextOffset), CaxtonShaders.TEXT_OUTLINE);
            }
            return new GlyphRenderTypes(this.text.computeIfAbsent(page, this.ofText), this.textSeeThrough.computeIfAbsent(page, this.ofTextSeeThrough), this.textOffset.computeIfAbsent(page, this.ofTextOffset), this.pipeline);
        }
    }

    private static abstract class RenderLayerFunctions
    extends RenderType {
        public RenderLayerFunctions(String name, int size, boolean hasCrumbling, boolean translucent, Runnable begin, Runnable end) {
            super(name, size, hasCrumbling, translucent, begin, end);
        }

        private static RenderType make(String name, RenderPipeline pipeline, CaxtonAtlas.Page page, boolean rasterized) {
            return RenderType.create((String)name, (int)786432, (boolean)false, (boolean)false, (RenderPipeline)pipeline, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(page.getId(), page.getNumMipmapLevels() > 1)).setLightmapState(LIGHTMAP).setTexturingState(rasterized ? RenderStateShard.DEFAULT_TEXTURING : new RenderStateShard.TexturingStateShard("set_unit_range", () -> {
                CaxtonShaders.currentUnitRangeBuffer = page.getUnitRangeBuffer();
            }, () -> {
                CaxtonShaders.currentUnitRangeBuffer = null;
            })).createCompositeState(false));
        }

        private static RenderType ofText(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text", CaxtonShaders.TEXT, page, false);
        }

        private static RenderType ofTextSeeThrough(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through", CaxtonShaders.TEXT_SEE_THROUGH, page, false);
        }

        private static RenderType ofTextOffset(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_polygon_offset", CaxtonShaders.TEXT_OFFSET, page, false);
        }

        private static RenderType ofTextOutline(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline", CaxtonShaders.TEXT_OUTLINE, page, false);
        }

        private static RenderType ofTextR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_raster", RenderPipelines.TEXT_INTENSITY, page, true);
        }

        private static RenderType ofTextSeeThroughR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through_raster", RenderPipelines.TEXT_INTENSITY_SEE_THROUGH, page, true);
        }

        private static RenderType ofTextOffsetR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline_raster", RenderPipelines.TEXT_INTENSITY, page, true);
        }
    }
}

