/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.SequencedMap;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import xyz.flirora.caxton.mixin.RenderPhaseAccessor;

@OnlyIn(value=Dist.CLIENT)
public class WorldRendererVertexConsumerProvider
extends MultiBufferSource.BufferSource {
    private static final Set<String> CAXTON_TEXT_RENDER_LAYER_NAMES = ImmutableSet.of((Object)"caxton_text", (Object)"caxton_text_see_through", (Object)"caxton_text_outline", (Object)"caxton_text_polygon_offset");
    private final Map<RenderType, ByteBufferBuilder> caxtonTextLayerAllocators = new HashMap<RenderType, ByteBufferBuilder>();
    private final Map<RenderType, BufferBuilder> caxtonTextLayerBuilders = new HashMap<RenderType, BufferBuilder>();

    public WorldRendererVertexConsumerProvider(ByteBufferBuilder fallbackBuffer, SequencedMap<RenderType, ByteBufferBuilder> layerBuffers) {
        super(fallbackBuffer, layerBuffers);
    }

    private static boolean isCaxtonTextLayer(RenderType layer) {
        return CAXTON_TEXT_RENDER_LAYER_NAMES.contains(((RenderPhaseAccessor)layer).getName());
    }

    public VertexConsumer getBuffer(RenderType renderLayer) {
        BufferBuilder bufferBuilder = (BufferBuilder)this.startedBuilders.get(renderLayer);
        if (bufferBuilder != null && !renderLayer.canConsolidateConsecutiveGeometry() && !WorldRendererVertexConsumerProvider.isCaxtonTextLayer(renderLayer)) {
            this.draw(renderLayer, bufferBuilder);
            bufferBuilder = null;
        }
        if (bufferBuilder != null) {
            return bufferBuilder;
        }
        if (WorldRendererVertexConsumerProvider.isCaxtonTextLayer(renderLayer)) {
            ByteBufferBuilder bufferAllocator = this.caxtonTextLayerAllocators.computeIfAbsent(renderLayer, l -> new ByteBufferBuilder(256));
            return (VertexConsumer)this.caxtonTextLayerBuilders.computeIfAbsent(renderLayer, l -> new BufferBuilder(bufferAllocator, renderLayer.mode(), renderLayer.format()));
        }
        ByteBufferBuilder bufferAllocator = (ByteBufferBuilder)this.fixedBuffers.get(renderLayer);
        if (bufferAllocator != null) {
            bufferBuilder = new BufferBuilder(bufferAllocator, renderLayer.mode(), renderLayer.format());
        } else {
            if (this.lastSharedType != null && !WorldRendererVertexConsumerProvider.isCaxtonTextLayer(this.lastSharedType)) {
                this.endBatch(this.lastSharedType);
            }
            bufferBuilder = new BufferBuilder(this.sharedBuffer, renderLayer.mode(), renderLayer.format());
            this.lastSharedType = renderLayer;
        }
        if (WorldRendererVertexConsumerProvider.isCaxtonTextLayer(renderLayer)) {
            this.caxtonTextLayerBuilders.put(renderLayer, bufferBuilder);
        } else {
            this.startedBuilders.put(renderLayer, bufferBuilder);
        }
        return bufferBuilder;
    }

    public void endLastBatch() {
        if (this.lastSharedType != null) {
            if (!WorldRendererVertexConsumerProvider.isCaxtonTextLayer(this.lastSharedType) && !this.fixedBuffers.containsKey(this.lastSharedType)) {
                this.endBatch(this.lastSharedType);
            }
            this.lastSharedType = null;
        }
    }

    public void endBatch() {
        this.endLastBatch();
        this.drawCaxtonTextLayers();
        for (RenderType renderLayer : this.fixedBuffers.keySet()) {
            this.endBatch(renderLayer);
        }
    }

    public void drawCaxtonTextLayers() {
        for (Map.Entry<RenderType, BufferBuilder> entry : this.caxtonTextLayerBuilders.entrySet()) {
            RenderType layer = entry.getKey();
            BufferBuilder builder = entry.getValue();
            MeshData buffer = builder.build();
            if (buffer != null) {
                layer.draw(buffer);
            }
            if (!layer.equals(this.lastSharedType)) continue;
            this.lastSharedType = null;
        }
        this.caxtonTextLayerBuilders.clear();
    }

    public void endBatch(RenderType layer) {
        if (WorldRendererVertexConsumerProvider.isCaxtonTextLayer(layer)) {
            return;
        }
        BufferBuilder bufferBuilder = (BufferBuilder)this.startedBuilders.remove(layer);
        if (bufferBuilder != null) {
            this.draw(layer, bufferBuilder);
        }
    }

    private void draw(RenderType layer, BufferBuilder builder) {
        MeshData builtBuffer = builder.build();
        if (builtBuffer != null) {
            if (layer.sortOnUpload()) {
                ByteBufferBuilder bufferAllocator = this.fixedBuffers.getOrDefault(layer, this.sharedBuffer);
                builtBuffer.sortQuads(bufferAllocator, RenderSystem.getProjectionType().vertexSorting());
            }
            layer.draw(builtBuffer);
        }
        if (layer.equals(this.lastSharedType)) {
            this.lastSharedType = null;
        }
    }
}

