/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_4668;
import net.minecraft.class_8538;
import xyz.flirora.caxton.font.FontTech;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonShaders;
import xyz.flirora.caxton.render.CaxtonTextLayerType;

@Environment(value=EnvType.CLIENT)
public class CaxtonTextRenderLayers {
    private final Group msdf = new Group(RenderLayerFunctions::ofText, RenderLayerFunctions::ofTextSeeThrough, RenderLayerFunctions::ofTextOffset, RenderLayerFunctions::ofTextOutline, CaxtonShaders.TEXT);
    private final Group raster = new Group(RenderLayerFunctions::ofTextR, RenderLayerFunctions::ofTextSeeThroughR, RenderLayerFunctions::ofTextOffsetR, RenderLayerFunctions::ofTextR, class_10799.field_56820);

    public void clear() {
        this.msdf.clear();
        this.raster.clear();
    }

    public class_1921 text(CaxtonAtlas.Page page, CaxtonTextLayerType layerType, FontTech tech) {
        return switch (tech) {
            default -> throw new MatchException(null, null);
            case FontTech.MSDF -> this.msdf.text(page, layerType);
            case FontTech.RASTER -> this.raster.text(page, layerType);
        };
    }

    public class_8538 renderLayerSet(CaxtonAtlas.Page page, FontTech tech, boolean outline) {
        return switch (tech) {
            default -> throw new MatchException(null, null);
            case FontTech.MSDF -> this.msdf.renderLayerSet(page, outline);
            case FontTech.RASTER -> this.raster.renderLayerSet(page, outline);
        };
    }

    public static class Group {
        private final ConcurrentHashMap<CaxtonAtlas.Page, class_1921> text = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, class_1921> textSeeThrough = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, class_1921> textOffset = new ConcurrentHashMap();
        private final ConcurrentHashMap<CaxtonAtlas.Page, class_1921> textOutline = new ConcurrentHashMap();
        private final Function<CaxtonAtlas.Page, class_1921> ofText;
        private final Function<CaxtonAtlas.Page, class_1921> ofTextSeeThrough;
        private final Function<CaxtonAtlas.Page, class_1921> ofTextOffset;
        private final Function<CaxtonAtlas.Page, class_1921> ofTextOutline;
        private final RenderPipeline pipeline;

        public Group(Function<CaxtonAtlas.Page, class_1921> ofText, Function<CaxtonAtlas.Page, class_1921> ofTextSeeThrough, Function<CaxtonAtlas.Page, class_1921> ofTextOffset, Function<CaxtonAtlas.Page, class_1921> ofTextOutline, RenderPipeline pipeline) {
            this.ofText = ofText;
            this.ofTextSeeThrough = ofTextSeeThrough;
            this.ofTextOffset = ofTextOffset;
            this.ofTextOutline = ofTextOutline;
            this.pipeline = pipeline;
        }

        public void clear() {
            this.text.clear();
            this.textSeeThrough.clear();
            this.textOffset.clear();
            this.textOutline.clear();
        }

        public class_1921 text(CaxtonAtlas.Page page, CaxtonTextLayerType layerType) {
            return switch (layerType) {
                default -> throw new MatchException(null, null);
                case CaxtonTextLayerType.NORMAL -> this.text.computeIfAbsent(page, this.ofText);
                case CaxtonTextLayerType.SEE_THROUGH -> this.textSeeThrough.computeIfAbsent(page, this.ofTextSeeThrough);
                case CaxtonTextLayerType.OUTLINE -> this.textOutline.computeIfAbsent(page, this.ofTextOutline);
                case CaxtonTextLayerType.POLYGON_OFFSET -> this.textOffset.computeIfAbsent(page, this.ofTextOffset);
            };
        }

        public class_8538 renderLayerSet(CaxtonAtlas.Page page, boolean outline) {
            if (outline) {
                return new class_8538(this.textOutline.computeIfAbsent(page, this.ofTextOutline), this.textSeeThrough.computeIfAbsent(page, this.ofTextSeeThrough), this.textOffset.computeIfAbsent(page, this.ofTextOffset), CaxtonShaders.TEXT_OUTLINE);
            }
            return new class_8538(this.text.computeIfAbsent(page, this.ofText), this.textSeeThrough.computeIfAbsent(page, this.ofTextSeeThrough), this.textOffset.computeIfAbsent(page, this.ofTextOffset), this.pipeline);
        }
    }

    private static abstract class RenderLayerFunctions
    extends class_1921 {
        public RenderLayerFunctions(String name, int size, boolean hasCrumbling, boolean translucent, Runnable begin, Runnable end) {
            super(name, size, hasCrumbling, translucent, begin, end);
        }

        private static class_1921 make(String name, RenderPipeline pipeline, CaxtonAtlas.Page page, boolean rasterized) {
            return class_1921.method_24049((String)name, (int)786432, (boolean)false, (boolean)false, (RenderPipeline)pipeline, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(page.getId())).method_23608(field_21383).method_23614(rasterized ? class_4668.field_21379 : new class_4668.class_4684("set_unit_range", () -> {
                CaxtonShaders.currentUnitRangeBuffer = page.getUnitRangeBuffer();
            }, () -> {
                CaxtonShaders.currentUnitRangeBuffer = null;
            })).method_23617(false));
        }

        private static class_1921 ofText(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text", CaxtonShaders.TEXT, page, false);
        }

        private static class_1921 ofTextSeeThrough(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through", CaxtonShaders.TEXT_SEE_THROUGH, page, false);
        }

        private static class_1921 ofTextOffset(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_polygon_offset", CaxtonShaders.TEXT_OFFSET, page, false);
        }

        private static class_1921 ofTextOutline(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline", CaxtonShaders.TEXT_OUTLINE, page, false);
        }

        private static class_1921 ofTextR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_raster", class_10799.field_56820, page, true);
        }

        private static class_1921 ofTextSeeThroughR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_see_through_raster", class_10799.field_56824, page, true);
        }

        private static class_1921 ofTextOffsetR(CaxtonAtlas.Page page) {
            return RenderLayerFunctions.make("caxton_text_outline_raster", class_10799.field_56820, page, true);
        }
    }
}

