/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_11603;
import net.minecraft.class_11719;
import net.minecraft.class_11768;
import net.minecraft.class_11769;
import net.minecraft.class_1921;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_377;
import net.minecraft.class_378;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5225;
import net.minecraft.class_5481;
import net.minecraft.class_5819;
import net.minecraft.class_8030;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.slf4j.Logger;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonFontOptions;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.CaxtonTextHandler;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingResult;
import xyz.flirora.caxton.layout.Threshold;
import xyz.flirora.caxton.mixin.FontManagerAccessor;
import xyz.flirora.caxton.mixin.FontManagerFontsAccessor;
import xyz.flirora.caxton.mixin.TextRendererAccessor;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonGlyphCache;
import xyz.flirora.caxton.render.CaxtonTextDrawer;
import xyz.flirora.caxton.render.CaxtonTextLayerType;
import xyz.flirora.caxton.render.CaxtonTextRenderLayers;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;

@Environment(value=EnvType.CLIENT)
public class CaxtonTextRenderer {
    private static final Vector3f FORWARD_SHIFT = new Vector3f(0.0f, 0.0f, 0.03f);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final CaxtonTextHandler handler;
    final class_327 vanillaTextRenderer;
    private final class_5819 RANDOM = class_5819.method_43053();
    private CaxtonGlyphCache cache;
    private final Supplier<CaxtonGlyphCache> cacheSupplier;
    private final CaxtonTextRenderLayers renderLayers;
    public boolean rtl;
    private final boolean validatesAdvance;
    private final Function<class_2960, class_377> fontStorageAccessor;

    public CaxtonTextRenderer(class_327 vanillaTextRenderer, class_5225 vanillaTextHandler, Supplier<CaxtonGlyphCache> cacheSupplier) {
        this.vanillaTextRenderer = vanillaTextRenderer;
        this.fontStorageAccessor = ((FontManagerAccessor)((FontManagerFontsAccessor)this.getFonts()).getOuter())::callGetStorageInternal;
        this.handler = new CaxtonTextHandler(this.fontStorageAccessor, vanillaTextHandler);
        this.cacheSupplier = cacheSupplier;
        this.renderLayers = new CaxtonTextRenderLayers();
        this.validatesAdvance = ((FontManagerFontsAccessor)this.getFonts()).getAdvanceValidating();
    }

    public static CaxtonTextRenderer getInstance() {
        return ((HasCaxtonTextRenderer)class_310.method_1551().field_1772).getCaxtonTextRenderer();
    }

    public static CaxtonTextRenderer getAdvanceValidatingInstance() {
        return ((HasCaxtonTextRenderer)class_310.method_1551().field_39924).getCaxtonTextRenderer();
    }

    private static int tweakTransparency(int argb) {
        if ((argb & 0xFC000000) == 0) {
            return argb | 0xFF000000;
        }
        return argb;
    }

    private static float getMinThickness(Matrix4f modelView) {
        if (modelView.isAffine()) {
            class_1041 window = class_310.method_1551().method_22683();
            Vector3f v = new Vector3f(0.0f, 1.0f, 0.0f);
            modelView.transformDirection(v);
            v.mul((float)window.method_4480() / 2.0f, (float)window.method_4507() / 2.0f, 0.0f);
            float fontUnitYPx = class_3532.method_15355((float)(v.x * v.x + v.y * v.y));
            return 1.0f / fontUnitYPx;
        }
        return 0.0f;
    }

    public class_11603 getGlyphs(class_11719 source) {
        return ((TextRendererAccessor)this.vanillaTextRenderer).callGetGlyphs(source);
    }

    public class_378.class_11638 getFonts() {
        return (class_378.class_11638)((TextRendererAccessor)this.vanillaTextRenderer).getFonts();
    }

    public Function<class_2960, class_377> getFontStorageAccessor() {
        return this.fontStorageAccessor;
    }

    public boolean validatesAdvance() {
        return this.validatesAdvance;
    }

    public void drawWithOutline(class_5481 text, float x, float y, int color, int outlineColor, Matrix4f matrix, class_4597 vertexConsumers, int light, boolean addCorners) {
        Threshold NO_THRESHOLD = new Threshold();
        float minThickness = CaxtonTextRenderer.getMinThickness(matrix);
        CaxtonText runGroups = CaxtonText.from(text, this.fontStorageAccessor, this.validatesAdvance, this.rtl, this.handler.getCache());
        int effectiveOutlineColor = CaxtonTextRenderer.tweakTransparency(outlineColor);
        int effectiveColor = CaxtonTextRenderer.tweakTransparency(color);
        CaxtonTextDrawer outlineDrawer = new CaxtonTextDrawer(this, 0.0f, 0.0f, effectiveOutlineColor, false, false, Float.POSITIVE_INFINITY, NO_THRESHOLD).outlined();
        CaxtonTextDrawer centralDrawer = new CaxtonTextDrawer(this, x, y, effectiveColor, false, false, Float.POSITIVE_INFINITY, NO_THRESHOLD);
        for (RunGroup runGroup : runGroups.runGroups()) {
            ConfiguredCaxtonFont font = runGroup.getFont();
            if (font == null) {
                MutableFloat xBox = new MutableFloat();
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        if (dx == 0 && dy == 0 || !addCorners && dx != 0 && dy != 0) continue;
                        xBox.setValue(x);
                        int dxf = dx;
                        int dyf = dy;
                        runGroup.acceptRender((index, style, codePoint) -> {
                            int index2 = runGroup.getCharOffset() + index;
                            class_11768 glyph = ((TextRendererAccessor)this.vanillaTextRenderer).callGetGlyph(codePoint, style);
                            float shadowOffset = glyph.method_73398().method_16800();
                            outlineDrawer.setX(xBox.floatValue() + (float)dxf * shadowOffset);
                            outlineDrawer.setY(y + (float)dyf * shadowOffset);
                            xBox.add(glyph.method_73398().method_16798(style.method_10984()));
                            return outlineDrawer.accept(index2, style, codePoint);
                        });
                    }
                }
                centralDrawer.setX(x);
                runGroup.acceptRender((index, style, codePoint) -> {
                    int index2 = runGroup.getCharOffset() + index;
                    return centralDrawer.accept(index2, style, codePoint);
                });
                x = centralDrawer.getX();
            } else {
                ShapingResult[] shapingResults = runGroup.getShapingResults();
                int outlinedGlyphOffset = font.font().getOptions().fontTech().offsetOutlineGlyphsByGlyphCounts() ? font.font().getGlyphCount() : 0;
                for (int i = 0; i < shapingResults.length; ++i) {
                    ShapingResult shapingResult = shapingResults[i];
                    this.drawShapedRun(shapingResult, runGroup, i, x, y, false, matrix, vertexConsumers, CaxtonTextLayerType.OUTLINE, light, outlineDrawer, NO_THRESHOLD, Float.POSITIVE_INFINITY, minThickness, outlinedGlyphOffset);
                    x = this.drawShapedRun(shapingResult, runGroup, i, x, y, false, matrix, vertexConsumers, CaxtonTextLayerType.POLYGON_OFFSET, light, centralDrawer, NO_THRESHOLD, Float.POSITIVE_INFINITY, minThickness, 0);
                }
            }
            outlineDrawer.method_71801(class_327.class_11464.method_71799((class_4597)vertexConsumers, (Matrix4f)matrix, (class_327.class_6415)class_327.class_6415.field_33993, (int)light));
            centralDrawer.method_71801(class_327.class_11464.method_71799((class_4597)vertexConsumers, (Matrix4f)matrix, (class_327.class_6415)class_327.class_6415.field_33995, (int)light));
        }
    }

    private float drawShapedRun(ShapingResult shapedRun, RunGroup runGroup, int index, float x, float y, boolean shadow, Matrix4f matrix, class_4597 vertexConsumers, CaxtonTextLayerType layerType, int light, CaxtonTextDrawer drawer, Threshold threshold, float maxX, float minThickness, int glyphOffset) {
        if (x >= maxX) {
            return x;
        }
        ConfiguredCaxtonFont configuredFont = runGroup.getFont();
        CaxtonFont font = configuredFont.font();
        CaxtonFontOptions options = font.getOptions();
        CaxtonGlyphCache.Font cacheForFont = this.cache.forFont(font);
        class_11769 rectangle = this.getFonts().method_73366();
        assert (glyphOffset + font.getGlyphCount() <= font.getTlistSize());
        double shrink = options.shrinkage();
        int margin = options.margin();
        float shadowOffset = configuredFont.shadowOffset();
        float textZ = shadow ? 0.03f : 0.0f;
        float pageSize = CaxtonAtlas.PAGE_SIZE;
        int offset = runGroup.getBidiRuns()[4 * index + 0];
        short underlinePosition = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_POSITION);
        short underlineThickness = font.getMetrics(CaxtonFont.Metrics.UNDERLINE_THICKNESS);
        short strikeoutPosition = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_POSITION);
        short strikeoutThickness = font.getMetrics(CaxtonFont.Metrics.STRIKEOUT_THICKNESS);
        float scale = configuredFont.getScale();
        float baselineY = y + 7.0f + configuredFont.shiftY();
        x += configuredFont.shiftX();
        float yu = baselineY - (float)underlinePosition * scale;
        float ys = baselineY - (float)strikeoutPosition * scale;
        float dyu = (float)underlineThickness * scale;
        float dys = (float)strikeoutThickness * scale;
        float ou = 0.5f * dyu;
        float os = 0.5f * dys;
        if (dyu < minThickness) {
            dyu = minThickness;
        }
        if (dys < minThickness) {
            dys = minThickness;
        }
        float y0u = yu + 0.5f * dyu;
        float y1u = yu - 0.5f * dyu;
        float y0s = ys + 0.5f * dys;
        float y1s = ys - 0.5f * dys;
        int numGlyphs = shapedRun.numGlyphs();
        int cumulAdvanceX = 0;
        for (int i = 0; i < numGlyphs; ++i) {
            int glyphId = shapedRun.glyphId(i);
            int clusterIndex = shapedRun.clusterIndex(i);
            if (threshold.updateCaxton(runGroup, index, shapedRun, i)) continue;
            class_2583 style = runGroup.getStyleAt(offset + clusterIndex);
            if (style.method_10987()) {
                long tlLoc = font.getTlistLocation(glyphId, 0);
                int width = (int)(tlLoc & 0xFFFFL);
                IntList others = (IntList)font.getGlyphsByWidth().get(width);
                glyphId = others.getInt(this.RANDOM.method_43048(others.size()));
            }
            int textColor = drawer.getRenderColor(style.method_10973());
            int shadowColor = drawer.getShadowColor(style, textColor);
            int advanceX = shapedRun.advanceX(i);
            int offsetX = shapedRun.offsetX(i);
            int offsetY = shapedRun.offsetY(i);
            int gx = cumulAdvanceX + offsetX;
            long atlasLoc = cacheForFont.getOrCreateAtlasLocation(glyphOffset + glyphId);
            if (atlasLoc != 0L) {
                int atlasX = CaxtonAtlas.getX(atlasLoc);
                int atlasY = CaxtonAtlas.getY(atlasLoc);
                int atlasWidth = CaxtonAtlas.getW(atlasLoc);
                int atlasHeight = CaxtonAtlas.getH(atlasLoc);
                int atlasPageIndex = CaxtonAtlas.getPage(atlasLoc);
                CaxtonAtlas.Page atlasPage = this.cache.getAtlasPageTexture(atlasPageIndex);
                long glyphBbox = font.getBbox(glyphId);
                short bbXMin = (short)glyphBbox;
                short bbYMin = (short)(glyphBbox >> 16);
                short bbXMax = (short)(glyphBbox >> 32);
                short bbYMax = (short)(glyphBbox >> 48);
                int bbWidth = bbXMax - bbXMin;
                int bbHeight = bbYMax - bbYMin;
                class_1921 renderLayer = this.renderLayers.text(atlasPage, layerType, options.fontTech());
                class_4588 vertexConsumer = vertexConsumers.method_73477(renderLayer);
                float x0 = (float)((double)x + ((double)(gx += bbXMin) - shrink * (double)margin) * (double)scale);
                float y1 = (float)(((double)(-(offsetY += bbYMin)) + shrink * (double)margin) * (double)scale);
                float u0 = (float)atlasX / pageSize;
                float v0 = (float)atlasY / pageSize;
                float x1 = (float)((double)x + ((double)gx + shrink * (double)(atlasWidth - margin)) * (double)scale);
                float y0 = (float)(((double)(-offsetY) - shrink * (double)(atlasHeight - margin)) * (double)scale);
                float u1 = (float)(atlasX + atlasWidth) / pageSize;
                float v1 = (float)(atlasY + atlasHeight) / pageSize;
                float lowerOffset = configuredFont.slant() * y0;
                float upperOffset = configuredFont.slant() * y1;
                y0 += baselineY;
                y1 += baselineY;
                if (x1 >= maxX) break;
                vertexConsumer.method_22918((Matrix4fc)matrix, x0 + lowerOffset, y0, textZ).method_39415(textColor);
                vertexConsumer.method_22913(u0, v0).method_60803(light);
                vertexConsumer.method_22918((Matrix4fc)matrix, x0 + upperOffset, y1, textZ).method_39415(textColor);
                vertexConsumer.method_22913(u0, v1).method_60803(light);
                vertexConsumer.method_22918((Matrix4fc)matrix, x1 + upperOffset, y1, textZ).method_39415(textColor);
                vertexConsumer.method_22913(u1, v1).method_60803(light);
                vertexConsumer.method_22918((Matrix4fc)matrix, x1 + lowerOffset, y0, textZ).method_39415(textColor);
                vertexConsumer.method_22913(u1, v0).method_60803(light);
                if (shadow) {
                    x1 += shadowOffset;
                    vertexConsumer.method_22918((Matrix4fc)matrix, (x0 += shadowOffset) + lowerOffset, y0 += shadowOffset, 0.0f).method_39415(shadowColor);
                    vertexConsumer.method_22913(u0, v0).method_60803(light);
                    vertexConsumer.method_22918((Matrix4fc)matrix, x0 + upperOffset, y1 += shadowOffset, 0.0f).method_39415(shadowColor);
                    vertexConsumer.method_22913(u0, v1).method_60803(light);
                    vertexConsumer.method_22918((Matrix4fc)matrix, x1 + upperOffset, y1, 0.0f).method_39415(shadowColor);
                    vertexConsumer.method_22913(u1, v1).method_60803(light);
                    vertexConsumer.method_22918((Matrix4fc)matrix, x1 + lowerOffset, y0, 0.0f).method_39415(shadowColor);
                    vertexConsumer.method_22913(u1, v0).method_60803(light);
                }
            }
            float x0a = x + (float)cumulAdvanceX * scale;
            float x1a = x + (float)(cumulAdvanceX + advanceX) * scale;
            if (style.method_10965()) {
                drawer.addRectangle(rectangle.method_73406(x0a, y0u, x1a, y1u, drawer.getForegroundZIndex() + textZ, textColor, shadowColor, shadowOffset));
            }
            if (style.method_10986()) {
                drawer.addRectangle(rectangle.method_73406(x0a, y0s, x1a, y1s, drawer.getForegroundZIndex() + textZ, textColor, shadowColor, shadowOffset));
            }
            cumulAdvanceX += advanceX;
        }
        return x + (float)cumulAdvanceX * scale - configuredFont.shiftX();
    }

    public class_327.class_11465 prepare(CaxtonText text, float x, float y, int color, boolean shadow, boolean trackSkeletons, int backgroundColor, int leftmostCodePoint, float maxWidth) {
        this.getCache();
        float minThickness = CaxtonTextRenderer.getMinThickness(RenderSystem.getModelViewMatrix());
        CaxtonTextDrawer drawer = new CaxtonTextDrawer(this, x, y, color, backgroundColor, shadow, trackSkeletons, x + maxWidth, new Threshold(leftmostCodePoint));
        for (RunGroup runGroup : text.runGroups()) {
            if (runGroup.getFont() == null) {
                runGroup.acceptRender((index, style, codePoint) -> {
                    int index2 = runGroup.getCharOffset() + index;
                    return drawer.accept(index2, style, codePoint);
                });
                continue;
            }
            ShapingResult[] shapingResults = runGroup.getShapingResults();
            for (int index2 = 0; index2 < shapingResults.length; ++index2) {
                ShapingResult shapingResult = shapingResults[index2];
                drawer.acceptShapedRun(shapingResult, runGroup, index2, this.cache, 0, minThickness, this.renderLayers);
            }
        }
        return drawer;
    }

    public class_327.class_11465 prepareOutlined(CaxtonText runGroups, float x, float y, int color, int outlineColor, int light, boolean addCorners) {
        this.getCache();
        Threshold NO_THRESHOLD = new Threshold();
        float minThickness = CaxtonTextRenderer.getMinThickness(RenderSystem.getModelViewMatrix());
        int effectiveOutlineColor = CaxtonTextRenderer.tweakTransparency(outlineColor);
        int effectiveColor = CaxtonTextRenderer.tweakTransparency(color);
        final CaxtonTextDrawer outlineDrawer = new CaxtonTextDrawer(this, 0.0f, 0.0f, effectiveOutlineColor, false, false, Float.POSITIVE_INFINITY, NO_THRESHOLD).outlined();
        final CaxtonTextDrawer centralDrawer = new CaxtonTextDrawer(this, x, y, effectiveColor, false, false, Float.POSITIVE_INFINITY, NO_THRESHOLD);
        for (RunGroup runGroup : runGroups.runGroups()) {
            ConfiguredCaxtonFont font = runGroup.getFont();
            if (font == null) {
                MutableFloat xBox = new MutableFloat();
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        if (dx == 0 && dy == 0 || !addCorners && dx != 0 && dy != 0) continue;
                        xBox.setValue(x);
                        int dxf = dx;
                        int dyf = dy;
                        runGroup.acceptRender((index, style, codePoint) -> {
                            int index2 = runGroup.getCharOffset() + index;
                            class_11768 glyph = ((TextRendererAccessor)this.vanillaTextRenderer).callGetGlyph(codePoint, style);
                            float shadowOffset = glyph.method_73398().method_16800();
                            outlineDrawer.setX(xBox.floatValue() + (float)dxf * shadowOffset);
                            outlineDrawer.setY(y + (float)dyf * shadowOffset);
                            xBox.add(glyph.method_73398().method_16798(style.method_10984()));
                            return outlineDrawer.accept(index2, style, codePoint);
                        });
                    }
                }
                centralDrawer.setX(x);
                runGroup.acceptRender((index, style, codePoint) -> {
                    int index2 = runGroup.getCharOffset() + index;
                    return centralDrawer.accept(index2, style, codePoint);
                });
                x = centralDrawer.getX();
                continue;
            }
            ShapingResult[] shapingResults = runGroup.getShapingResults();
            int outlinedGlyphOffset = font.font().getOptions().fontTech().offsetOutlineGlyphsByGlyphCounts() ? font.font().getGlyphCount() : 0;
            for (int i = 0; i < shapingResults.length; ++i) {
                ShapingResult shapingResult = shapingResults[i];
                centralDrawer.acceptShapedRun(shapingResult, runGroup, i, this.cache, 0, minThickness, this.renderLayers);
                outlineDrawer.setX(x);
                outlineDrawer.setY(y);
                outlineDrawer.acceptShapedRun(shapingResult, runGroup, i, this.cache, outlinedGlyphOffset, minThickness, this.renderLayers);
                x = centralDrawer.getX();
            }
        }
        return new class_327.class_11465(){

            public void method_71801(class_327.class_11464 glyphDrawer) {
                outlineDrawer.method_71801(glyphDrawer);
                centralDrawer.method_71801(glyphDrawer);
            }

            @Nullable
            public class_8030 method_71800() {
                class_8030 rect1 = outlineDrawer.method_71800();
                class_8030 rect2 = centralDrawer.method_71800();
                if (rect1 == null) {
                    return rect2;
                }
                if (rect2 == null) {
                    return rect1;
                }
                int left = Math.min(rect1.method_49620(), rect2.method_49620());
                int right = Math.max(rect1.method_49621(), rect2.method_49621());
                int top = Math.min(rect1.method_49618(), rect2.method_49618());
                int bottom = Math.max(rect1.method_49619(), rect2.method_49619());
                return new class_8030(left, top, right - left, bottom - top);
            }
        };
    }

    public CaxtonGlyphCache getCache() {
        RenderSystem.assertOnRenderThread();
        if (this.cache == null) {
            this.cache = this.cacheSupplier.get();
        }
        return this.cache;
    }

    public void clearCaches() {
        RenderSystem.assertOnRenderThread();
        this.handler.clearCaches();
        LOGGER.info("Cleared layout caches");
        if (this.cache != null) {
            this.cache.clear();
        }
        this.renderLayers.clear();
        LOGGER.info("Cleared rendering caches");
    }

    public CaxtonTextHandler getHandler() {
        return this.handler;
    }

    public CaxtonText from(class_5481 text) {
        return CaxtonText.from(text, this.fontStorageAccessor, this.validatesAdvance, this.rtl, this.handler.getCache());
    }

    public CaxtonText fromForwards(String text, class_2583 style) {
        return CaxtonText.fromForwards(text, this.fontStorageAccessor, style, this.validatesAdvance, this.rtl, this.handler.getCache());
    }
}

