/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.SequencedMap;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import xyz.flirora.caxton.mixin.RenderPhaseAccessor;

@Environment(value=EnvType.CLIENT)
public class WorldRendererVertexConsumerProvider
extends class_4597.class_4598 {
    private static final Set<String> CAXTON_TEXT_RENDER_LAYER_NAMES = ImmutableSet.of((Object)"caxton_text", (Object)"caxton_text_see_through", (Object)"caxton_text_outline", (Object)"caxton_text_polygon_offset");
    private final Map<class_1921, class_9799> caxtonTextLayerAllocators = new HashMap<class_1921, class_9799>();
    private final Map<class_1921, class_287> caxtonTextLayerBuilders = new HashMap<class_1921, class_287>();

    public WorldRendererVertexConsumerProvider(class_9799 fallbackBuffer, SequencedMap<class_1921, class_9799> layerBuffers) {
        super(fallbackBuffer, layerBuffers);
    }

    private static boolean isCaxtonTextLayer(class_1921 layer) {
        return CAXTON_TEXT_RENDER_LAYER_NAMES.contains(((RenderPhaseAccessor)layer).getName());
    }

    public class_4588 method_73477(class_1921 renderLayer) {
        class_287 bufferBuilder = (class_287)this.field_52157.get(renderLayer);
        if (bufferBuilder != null && !renderLayer.method_43332() && !WorldRendererVertexConsumerProvider.isCaxtonTextLayer(renderLayer)) {
            this.draw(renderLayer, bufferBuilder);
            bufferBuilder = null;
        }
        if (bufferBuilder != null) {
            return bufferBuilder;
        }
        if (WorldRendererVertexConsumerProvider.isCaxtonTextLayer(renderLayer)) {
            class_9799 bufferAllocator = this.caxtonTextLayerAllocators.computeIfAbsent(renderLayer, l -> new class_9799(256));
            return (class_4588)this.caxtonTextLayerBuilders.computeIfAbsent(renderLayer, l -> new class_287(bufferAllocator, renderLayer.method_23033(), renderLayer.method_23031()));
        }
        class_9799 bufferAllocator = (class_9799)this.field_20953.get(renderLayer);
        if (bufferAllocator != null) {
            bufferBuilder = new class_287(bufferAllocator, renderLayer.method_23033(), renderLayer.method_23031());
        } else {
            if (this.field_52158 != null && !WorldRendererVertexConsumerProvider.isCaxtonTextLayer(this.field_52158)) {
                this.method_22994(this.field_52158);
            }
            bufferBuilder = new class_287(this.field_52156, renderLayer.method_23033(), renderLayer.method_23031());
            this.field_52158 = renderLayer;
        }
        if (WorldRendererVertexConsumerProvider.isCaxtonTextLayer(renderLayer)) {
            this.caxtonTextLayerBuilders.put(renderLayer, bufferBuilder);
        } else {
            this.field_52157.put(renderLayer, bufferBuilder);
        }
        return bufferBuilder;
    }

    public void method_37104() {
        if (this.field_52158 != null) {
            if (!WorldRendererVertexConsumerProvider.isCaxtonTextLayer(this.field_52158) && !this.field_20953.containsKey(this.field_52158)) {
                this.method_22994(this.field_52158);
            }
            this.field_52158 = null;
        }
    }

    public void method_22993() {
        this.method_37104();
        this.drawCaxtonTextLayers();
        for (class_1921 renderLayer : this.field_20953.keySet()) {
            this.method_22994(renderLayer);
        }
    }

    public void drawCaxtonTextLayers() {
        for (Map.Entry<class_1921, class_287> entry : this.caxtonTextLayerBuilders.entrySet()) {
            class_1921 layer = entry.getKey();
            class_287 builder = entry.getValue();
            class_9801 buffer = builder.method_60794();
            if (buffer != null) {
                layer.method_60895(buffer);
            }
            if (!layer.equals(this.field_52158)) continue;
            this.field_52158 = null;
        }
        this.caxtonTextLayerBuilders.clear();
    }

    public void method_22994(class_1921 layer) {
        if (WorldRendererVertexConsumerProvider.isCaxtonTextLayer(layer)) {
            return;
        }
        class_287 bufferBuilder = (class_287)this.field_52157.remove(layer);
        if (bufferBuilder != null) {
            this.draw(layer, bufferBuilder);
        }
    }

    private void draw(class_1921 layer, class_287 builder) {
        class_9801 builtBuffer = builder.method_60794();
        if (builtBuffer != null) {
            if (layer.method_60894()) {
                class_9799 bufferAllocator = this.field_20953.getOrDefault(layer, this.field_52156);
                builtBuffer.method_60819(bufferAllocator, RenderSystem.getProjectionType().method_65045());
            }
            layer.method_60895(builtBuffer);
        }
        if (layer.equals(this.field_52158)) {
            this.field_52158 = null;
        }
    }
}

