/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;
import xyz.flirora.caxton.command.ClientCommandSource;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.render.CaxtonAtlas;
import xyz.flirora.caxton.render.CaxtonGlyphCache;
import xyz.flirora.caxton.render.CaxtonTextRenderer;
import xyz.flirora.caxton.render.HasCaxtonTextRenderer;

public class DumpAtlasCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DynamicCommandExceptionType ATLAS_FAILED = new DynamicCommandExceptionType(i -> Component.m_237110_((String)"caxton.command.caxtondumpatlas.atlasFailed", (Object[])new Object[]{i}));
    private static final SimpleCommandExceptionType LOCATION_DATA_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"caxton.command.caxtondumpatlas.locationDataFailed"));

    public static int run(CommandContext<?> context, ClientCommandSource source) throws CommandSyntaxException {
        Minecraft client = source.getClient();
        File debugDir = new File(client.f_91069_, "debug");
        File outputDir = new File(debugDir, "dumped-atlas-" + Util.m_241986_() + "-client");
        outputDir.mkdirs();
        Font vanillaRenderer = client.f_91062_;
        CaxtonTextRenderer caxtonRenderer = ((HasCaxtonTextRenderer)vanillaRenderer).getCaxtonTextRenderer();
        CaxtonGlyphCache cache = caxtonRenderer.getCache();
        List<CaxtonAtlas.Page> pages = cache.getAtlas().getAllPages();
        for (int i = 0; i < pages.size(); ++i) {
            CaxtonAtlas.Page page = pages.get(i);
            int numMipmaps = page.getNumMipmapLevels();
            GlStateManager.m_84544_((int)page.m_117963_());
            for (int mipmap = 0; mipmap < numMipmaps; ++mipmap) {
                String name = mipmap > 0 ? "page" + i + "_lv" + mipmap + ".png" : "page" + i + ".png";
                File imageOut = new File(outputDir, name);
                try (NativeImage image = new NativeImage(CaxtonAtlas.PAGE_SIZE >> mipmap, CaxtonAtlas.PAGE_SIZE >> mipmap, false);){
                    image.m_85045_(mipmap, false);
                    image.m_85056_(imageOut);
                    continue;
                }
                catch (Exception exception) {
                    LOGGER.warn("Couldn\u2019t save atlas page #" + i + ", level " + mipmap, (Throwable)exception);
                    throw ATLAS_FAILED.create((Object)i);
                }
            }
        }
        Map<CaxtonFont, Int2LongMap> locations = cache.getLocations();
        File locationsOut = new File(outputDir, "locations.json");
        try (FileWriter writer = new FileWriter(locationsOut);
             JsonWriter jsonWriter = GSON.newJsonWriter((Writer)writer);){
            jsonWriter.beginObject();
            for (Map.Entry<CaxtonFont, Int2LongMap> fontEntry : locations.entrySet()) {
                CaxtonFont font = fontEntry.getKey();
                jsonWriter.name(font.getId().toString());
                jsonWriter.beginObject();
                for (Int2LongMap.Entry locationEntry : fontEntry.getValue().int2LongEntrySet()) {
                    int glyphId = locationEntry.getIntKey();
                    String glyphName = font.getGlyphName(glyphId);
                    jsonWriter.name((String)(glyphName != null ? glyphName : "_glyph" + glyphId));
                    jsonWriter.beginObject();
                    long location = locationEntry.getLongValue();
                    jsonWriter.name("id").value((long)glyphId);
                    jsonWriter.name("x").value((long)CaxtonAtlas.getX(location));
                    jsonWriter.name("y").value((long)CaxtonAtlas.getY(location));
                    jsonWriter.name("width").value((long)CaxtonAtlas.getW(location));
                    jsonWriter.name("height").value((long)CaxtonAtlas.getH(location));
                    jsonWriter.name("page").value((long)CaxtonAtlas.getPage(location));
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Exception exception) {
            LOGGER.warn("Couldn\u2019t save location data", (Throwable)exception);
            throw LOCATION_DATA_FAILED.create();
        }
        source.sendFeedback(() -> Component.m_237110_((String)"caxton.command.caxtondumpatlas.success", (Object[])new Object[]{outputDir}));
        return 1;
    }
}

