/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.dll;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import java.util.Scanner;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.Platform;
import org.slf4j.Logger;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.dll.RustPlatform;
import xyz.flirora.caxton.dll.UnsupportedPlatformException;

public class LibraryLoading {
    private static final Component UNSUPPORTED_PLATFORM = Component.m_237115_((String)"caxton.gui.unsupportedPlatform").m_130940_(ChatFormatting.BOLD);
    private static final Component LIBRARY_LOADING_FAILED = Component.m_237115_((String)"caxton.gui.libraryLoadingFailed").m_130940_(ChatFormatting.BOLD);
    private static final Component UNSUPPORTED_PLATFORM_DESC = Component.m_237115_((String)"caxton.gui.unsupportedPlatform.description");
    private static final Component UNSUPPORTED_PLATFORM_DESC_OSX = Component.m_237115_((String)"caxton.gui.unsupportedPlatform.description.osx").m_7220_((Component)Component.m_237115_((String)"caxton.gui.unsupportedPlatform.description.osx2").m_130940_(ChatFormatting.BOLD));
    private static final Component LIBRARY_LOADING_FAILED_DESC = Component.m_237115_((String)"caxton.gui.libraryLoadingFailed.description");
    public static final String ISSUES_URL = "https://gitlab.com/Kyarei/caxton/-/issues";
    private static final Component LIBRARY_LOADING_FAILED_LINK = Component.m_237110_((String)"caxton.gui.libraryLoadingFailed.link", (Object[])new Object[]{"https://gitlab.com/Kyarei/caxton/-/issues"});
    public static final String OS_SUPPORT_URL = "https://gitlab.com/Kyarei/caxton#os-support";
    private static final Component UNSUPPORTED_PLATFORM_LINK = Component.m_237110_((String)"caxton.gui.unsupportedPlatform.link", (Object[])new Object[]{"https://gitlab.com/Kyarei/caxton#os-support"});
    private static Exception loadingException = new IllegalStateException("library not yet loaded");

    public static Exception getLoadingException() {
        return loadingException;
    }

    public static boolean isLibraryLoaded() {
        return loadingException == null;
    }

    public static void loadNativeLibrary(Logger logger) {
        logger.info("Extracting and loading library for {} / {}", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.arch"));
        File runDirectory = Minecraft.m_91087_().f_91069_;
        String soName = System.mapLibraryName("caxton_impl");
        String soNameWithPlatform = RustPlatform.forCurrent() + "-" + soName;
        Metadata metadata = LibraryLoading.readFromChecksumsTxt(soNameWithPlatform, logger);
        try (InputStream libStream = CaxtonModClient.class.getResourceAsStream("/natives/" + soNameWithPlatform);){
            if (libStream == null) {
                throw new UnsupportedPlatformException("Could not find " + soNameWithPlatform);
            }
            File tmp = new File(runDirectory, soName);
            if (LibraryLoading.shouldRewrite(tmp, metadata, logger)) {
                logger.info("Writing native library to {}", (Object)tmp);
                try (FileOutputStream output = new FileOutputStream(tmp);){
                    libStream.transferTo(output);
                }
            } else {
                logger.info("Skipping copying native library because size and hash matched");
            }
            System.load(tmp.getAbsolutePath());
            loadingException = null;
        }
        catch (Exception e) {
            logger.error("Failed to load library", (Throwable)e);
            loadingException = e;
        }
    }

    private static boolean isMacOs() {
        return Platform.get() == Platform.MACOSX;
    }

    private static Component getTitle(Exception e) {
        return e instanceof UnsupportedPlatformException ? UNSUPPORTED_PLATFORM : LIBRARY_LOADING_FAILED;
    }

    private static Component getDescriptionText(Exception e) {
        boolean unsupported = e instanceof UnsupportedPlatformException;
        Component description = unsupported ? (LibraryLoading.isMacOs() ? UNSUPPORTED_PLATFORM_DESC_OSX : UNSUPPORTED_PLATFORM_DESC) : LIBRARY_LOADING_FAILED_DESC;
        Component link = unsupported ? UNSUPPORTED_PLATFORM_LINK : LIBRARY_LOADING_FAILED_LINK;
        return Component.m_237110_((String)"caxton.gui.failDescription", (Object[])new Object[]{description, System.getProperty("os.name"), System.getProperty("os.arch"), link});
    }

    public static Screen nativeLibraryLoadFailedScreen(BooleanConsumer callback, Exception e) {
        return new ConfirmLinkScreen(callback, LibraryLoading.getTitle(e), LibraryLoading.getDescriptionText(e), OS_SUPPORT_URL, CommonComponents.f_238584_, true);
    }

    public static void showNativeLibraryLoadFailedScreen(Minecraft client, Exception e) {
        Screen screen = client.f_91080_;
        client.m_91152_(LibraryLoading.nativeLibraryLoadFailedScreen(confirmed -> {
            if (confirmed) {
                String url = e instanceof UnsupportedPlatformException ? OS_SUPPORT_URL : ISSUES_URL;
                Util.m_137581_().m_137646_(url);
            }
            client.m_91152_(screen);
        }, e));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Metadata readFromChecksumsTxt(String soName, Logger logger) {
        try (InputStream checksums = CaxtonModClient.class.getResourceAsStream("/natives/checksums.txt");){
            String[] comps;
            block12: {
                Scanner scanner = new Scanner(Objects.requireNonNull(checksums, "checksums.txt not found"));
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.isEmpty()) continue;
                    comps = line.split("\t");
                    if (comps.length != 3) {
                        throw new IOException("Malformed line in checksums.txt: " + line);
                    }
                    if (!comps[0].equals(soName)) {
                        continue;
                    }
                    break block12;
                }
                return null;
            }
            Metadata metadata = new Metadata(Integer.parseInt(comps[1]), comps[2]);
            return metadata;
        }
        catch (IOException e) {
            logger.error("Could not read checksums.txt", (Throwable)e);
        }
        return null;
    }

    private static boolean shouldRewrite(File dest, @Nullable Metadata metadata, Logger logger) {
        try {
            if (metadata == null) {
                return true;
            }
            if (!dest.exists()) {
                return true;
            }
            if (Files.size(dest.toPath()) != (long)metadata.size) {
                return true;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream stream = new FileInputStream(dest);){
                byte[] contents;
                while ((contents = stream.readNBytes(4096)).length != 0) {
                    digest.update(contents);
                }
            }
            String digestStr = Base64.getEncoder().encodeToString(digest.digest());
            return !digestStr.equals(metadata.sha256Base64);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            logger.error("Could not determine whether we need to overwrite existing file in .minecraft; assuming that we do", (Throwable)e);
            return true;
        }
    }

    private record Metadata(int size, String sha256Base64) {
    }
}

