/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.client.gui.font.providers.GlyphProviderBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.flirora.caxton.dll.LibraryLoading;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonTypeface;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;

@OnlyIn(value=Dist.CLIENT)
public class CaxtonFontLoader
implements GlyphProviderBuilder {
    public static final String FONT_PREFIX = "textures/font/";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceLocation, CaxtonFont> CACHE = new ConcurrentHashMap<ResourceLocation, CaxtonFont>();
    private static final JsonObject EMPTY = new JsonObject();
    private final ConfiguredCaxtonFont.Loader regular;
    @Nullable
    private final ConfiguredCaxtonFont.Loader bold;
    @Nullable
    private final ConfiguredCaxtonFont.Loader italic;
    @Nullable
    private final ConfiguredCaxtonFont.Loader boldItalic;

    public CaxtonFontLoader(ConfiguredCaxtonFont.Loader regular, @Nullable ConfiguredCaxtonFont.Loader bold, @Nullable ConfiguredCaxtonFont.Loader italic, @Nullable ConfiguredCaxtonFont.Loader boldItalic) {
        this.regular = regular;
        this.bold = bold;
        this.italic = italic;
        this.boldItalic = boldItalic;
    }

    @Nullable
    private static ConfiguredCaxtonFont.Loader parseConfiguredFontLoader(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            return new ConfiguredCaxtonFont.Loader(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)object, (String)"file")), object);
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            return new ConfiguredCaxtonFont.Loader(ResourceLocation.m_135820_((String)primitive.getAsString()), null);
        }
        throw new JsonParseException("expected identifier or object; got something else");
    }

    @Nullable
    private static ResourceLocation getOptionalIdentifier(JsonObject json, String key) {
        String id = GsonHelper.m_13851_((JsonObject)json, (String)key, null);
        return id == null ? null : new ResourceLocation(id);
    }

    public static GlyphProviderBuilder fromJson(JsonObject json) {
        return new CaxtonFontLoader(CaxtonFontLoader.parseConfiguredFontLoader(json.get("regular")), CaxtonFontLoader.parseConfiguredFontLoader(json.get("bold")), CaxtonFontLoader.parseConfiguredFontLoader(json.get("italic")), CaxtonFontLoader.parseConfiguredFontLoader(json.get("bold_italic")));
    }

    @Nullable
    public static CaxtonFont loadFontByIdentifier(ResourceManager manager, @Nullable ResourceLocation id) {
        if (id == null) {
            return null;
        }
        return CACHE.computeIfAbsent(id, id1 -> {
            CaxtonFont caxtonFont;
            block17: {
                LOGGER.info("Loading font {}", (Object)id);
                ResourceLocation fontId = id1.m_246208_(FONT_PREFIX);
                ResourceLocation metaId = fontId.m_247266_(path -> path + ".json");
                JsonObject optionsJson = EMPTY;
                Optional metaResource = manager.m_213713_(metaId);
                if (metaResource.isPresent()) {
                    try (BufferedReader metaInput = ((Resource)metaResource.get()).m_215508_();){
                        optionsJson = GsonHelper.m_13859_((Reader)metaInput);
                        String path2 = GsonHelper.m_13851_((JsonObject)optionsJson, (String)"path", null);
                        if (path2 != null) {
                            fontId = new ResourceLocation(path2).m_246208_(FONT_PREFIX);
                        }
                    }
                }
                InputStream input = manager.m_215595_(fontId);
                try {
                    caxtonFont = new CaxtonFont(input, (ResourceLocation)id1, optionsJson);
                    if (input == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                input.close();
            }
            return caxtonFont;
        }).cloneReference();
    }

    public static void clearFontCache() {
        LOGGER.info("Clearing {} loaded font(s)", (Object)CACHE.size());
        CACHE.forEach((id, font) -> font.close());
        CACHE.clear();
    }

    public static CaxtonFont getFontById(ResourceLocation id) {
        return CACHE.get(id);
    }

    public static Stream<ResourceLocation> getAvailableFontIds() {
        System.err.println(CACHE);
        return CACHE.keySet().stream();
    }

    @Nullable
    public GlyphProvider m_6762_(ResourceManager manager) {
        if (!LibraryLoading.isLibraryLoaded()) {
            throw new RuntimeException("Refusing to load Caxton font when native library loading had failed");
        }
        try {
            ConfiguredCaxtonFont regular = ConfiguredCaxtonFont.load(manager, this.regular);
            ConfiguredCaxtonFont bold = ConfiguredCaxtonFont.load(manager, this.bold);
            ConfiguredCaxtonFont italic = ConfiguredCaxtonFont.load(manager, this.italic);
            ConfiguredCaxtonFont boldItalic = ConfiguredCaxtonFont.load(manager, this.boldItalic);
            return new CaxtonTypeface(regular, bold, italic, boldItalic);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load truetype font", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }
}

