/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import xyz.flirora.caxton.dll.CaxtonInternal;
import xyz.flirora.caxton.font.CaxtonFont;
import xyz.flirora.caxton.font.CaxtonFontLoader;
import xyz.flirora.caxton.layout.ShapingResult;

@OnlyIn(value=Dist.CLIENT)
public record ConfiguredCaxtonFont(CaxtonFont font, long ptr, float shadowOffset, float computedScaleFactor, boolean blur, float shiftX, float shiftY, float slant) implements AutoCloseable
{
    @Nullable
    public static ConfiguredCaxtonFont load(ResourceManager manager, @Nullable Loader settings) {
        if (settings == null) {
            return null;
        }
        String config = settings.settings == null ? null : settings.settings.toString();
        CaxtonFont font = CaxtonFontLoader.loadFontByIdentifier(manager, settings.id);
        if (font == null) {
            throw new RuntimeException("font " + String.valueOf(settings.id) + " does not exist");
        }
        long ptr = CaxtonInternal.configureFont(font.getFontPtr(), config);
        float shadowOffset = 1.0f;
        double scaleFactor = 1.0;
        boolean blur = false;
        float shiftX = 0.0f;
        float shiftY = 0.0f;
        float slant = 0.0f;
        if (settings.settings != null) {
            shadowOffset = GsonHelper.m_13820_((JsonObject)settings.settings, (String)"shadow_offset", (float)shadowOffset);
            scaleFactor = GsonHelper.m_144742_((JsonObject)settings.settings, (String)"scale_factor", (double)scaleFactor);
            blur = GsonHelper.m_13855_((JsonObject)settings.settings, (String)"blur", (boolean)blur);
            JsonElement shiftE = settings.settings.get("shift");
            if (shiftE instanceof JsonArray) {
                JsonArray shift = (JsonArray)shiftE;
                if (shift.size() != 2) {
                    throw new JsonSyntaxException("shift must have 2 elements");
                }
                shiftX = shift.get(0).getAsFloat();
                shiftY = shift.get(1).getAsFloat();
            } else if (shiftE != null) {
                throw new JsonSyntaxException("shift must be an array");
            }
            slant = -Float.intBitsToFloat(GsonHelper.m_13824_((JsonObject)settings.settings, (String)"the_font_designer_couldnt_be_assed_to_make_an_italic_variant_so_slant_the_text", (int)0));
        }
        float computedScaleFactor = (float)(7.0 * scaleFactor / (double)font.getMetrics(CaxtonFont.Metrics.ASCENDER));
        return new ConfiguredCaxtonFont(font, ptr, shadowOffset, computedScaleFactor, blur, shiftX, shiftY, slant);
    }

    @Override
    public void close() {
        CaxtonInternal.destroyConfiguredFont(this.ptr);
        this.font.close();
    }

    public float getScale() {
        return this.computedScaleFactor;
    }

    public ShapingResult[] shape(char[] s, int[] bidiRuns) {
        return CaxtonInternal.shape(this.ptr, s, bidiRuns);
    }

    public record Loader(ResourceLocation id, @Nullable JsonObject settings) {
    }
}

