/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.font;

import com.google.gson.JsonSyntaxException;

public enum FontTech {
    MSDF("msdf", false),
    RASTER("raster", true);

    private final String name;
    private final boolean offsetOutlineGlyphsByGlyphCounts;

    private FontTech(String name, boolean offsetOutlineGlyphsByGlyphCounts) {
        this.name = name;
        this.offsetOutlineGlyphsByGlyphCounts = offsetOutlineGlyphsByGlyphCounts;
    }

    public static FontTech fromName(String name) {
        return switch (name) {
            case "msdf" -> MSDF;
            case "raster" -> RASTER;
            default -> throw new JsonSyntaxException("invalid font tech: " + name);
        };
    }

    public String getName() {
        return this.name;
    }

    public boolean offsetOutlineGlyphsByGlyphCounts() {
        return this.offsetOutlineGlyphsByGlyphCounts;
    }
}

