/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.forge;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.locating.IModFile;
import xyz.flirora.caxton.CaxtonModClient;
import xyz.flirora.caxton.command.CaxtonCommands;
import xyz.flirora.caxton.forge.ClientCommandRegistrarResourceLocationFlavor;
import xyz.flirora.caxton.forge.PlatformHooksResourceLocationFlavor;
import xyz.flirora.caxton.render.CaxtonShaders;

@Mod(value="caxton")
public class CaxtonModResourceLocationFlavor {
    public CaxtonModResourceLocationFlavor() {
        MinecraftForge.EVENT_BUS.addListener(CaxtonModResourceLocationFlavor::registerCommands);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::addPackFinders);
        modBus.addListener(this::addShaders);
        CaxtonModClient.init(new PlatformHooksResourceLocationFlavor());
    }

    private void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            CaxtonModClient.LOGGER.info("Registering built-in resource packs");
            IModFile file = ModList.get().getModFileById("caxton").getFile();
            for (String id : CaxtonModClient.BUILTIN_PACKS) {
                Path sourcePath = file.findResource(new String[]{"resourcepacks/" + id});
                Pack pack = Pack.m_245429_((String)("caxton:" + id), (Component)Component.m_237115_((String)("caxton.resourcePack." + id)), (boolean)false, path -> new PathPackResources(path, sourcePath, false), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                event.addRepositorySource(profileAdder -> profileAdder.accept(pack));
            }
        }
    }

    private void addShaders(RegisterShadersEvent event) {
        try {
            CaxtonModClient.LOGGER.info("Registering core shaders");
            ResourceProvider factory = event.getResourceProvider();
            event.registerShader(new ShaderInstance(factory, CaxtonShaders.TEXT_ID, DefaultVertexFormat.f_85820_), shader -> {
                CaxtonShaders.caxtonTextShader = shader;
            });
            event.registerShader(new ShaderInstance(factory, CaxtonShaders.TEXT_SEE_THROUGH_ID, DefaultVertexFormat.f_85820_), shader -> {
                CaxtonShaders.caxtonTextSeeThroughShader = shader;
            });
            event.registerShader(new ShaderInstance(factory, CaxtonShaders.TEXT_OUTLINE_ID, DefaultVertexFormat.f_85820_), shader -> {
                CaxtonShaders.caxtonTextOutlineShader = shader;
            });
        }
        catch (IOException e) {
            throw new RuntimeException("could not add shaders", e);
        }
    }

    private static void registerCommands(RegisterClientCommandsEvent event) {
        CaxtonCommands.register(new ClientCommandRegistrarResourceLocationFlavor((CommandDispatcher<CommandSourceStack>)event.getDispatcher()));
    }
}

