/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.flirora.caxton.font.ConfiguredCaxtonFont;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.Run;
import xyz.flirora.caxton.layout.ShapedString;
import xyz.flirora.caxton.layout.ShapingResult;

@OnlyIn(value=Dist.CLIENT)
public class LayoutCache {
    private static final LayoutCache INSTANCE = new LayoutCache();
    private final Map<ConfiguredCaxtonFont, Cache<ShapedString, ShapingResult>> shapingCaches = new IdentityHashMap<ConfiguredCaxtonFont, Cache<ShapedString, ShapingResult>>();
    private final Cache<FromRunsInput, CaxtonText.Full> reorderCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterAccess(Duration.ofMinutes(1L)).build();

    private LayoutCache() {
    }

    public static LayoutCache getInstance() {
        return INSTANCE;
    }

    public Map<ConfiguredCaxtonFont, Cache<ShapedString, ShapingResult>> getShapingCaches() {
        return this.shapingCaches;
    }

    public Cache<ShapedString, ShapingResult> getShapingCacheFor(ConfiguredCaxtonFont font) {
        return this.shapingCaches.computeIfAbsent(font, f -> Caffeine.newBuilder().maximumSize(10000L).expireAfterAccess(Duration.ofMinutes(1L)).build());
    }

    public Cache<FromRunsInput, CaxtonText.Full> getReorderCache() {
        return this.reorderCache;
    }

    public void clear() {
        this.shapingCaches.clear();
        this.reorderCache.invalidateAll();
    }

    public record FromRunsInput(List<Run> runs, boolean rtl) {
    }
}

