/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Bidi;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import xyz.flirora.caxton.layout.LayoutCache;
import xyz.flirora.caxton.layout.Run;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ScriptTags;

public class ShapingRunSegmenter {
    private final String contents;
    private final Bidi bidi;
    private final List<RunGroup> runGroups;
    private final LayoutCache cache;
    private int charOffset = 0;
    private int currentBidiRun = 0;
    private int currentBidiStringIndex = 0;
    private final int totalBidiRuns;
    private final IntList bidiRunsList;

    public ShapingRunSegmenter(List<Run> runs, boolean rtl, LayoutCache cache) {
        this.contents = runs.stream().map(Run::text).collect(Collectors.joining());
        this.bidi = new Bidi(this.contents, rtl ? 127 : 126);
        this.runGroups = new ArrayList<RunGroup>();
        this.totalBidiRuns = this.bidi.countRuns();
        this.cache = cache;
        this.bidiRunsList = new IntArrayList(6);
        ArrayList<Run> last = null;
        for (Run run : runs) {
            if (last == null) {
                last = new ArrayList<Run>();
            } else if (!ShapingRunSegmenter.areRunsCompatible((Run)last.get(0), run)) {
                this.addRunGroup(last);
                last = new ArrayList();
            }
            last.add(run);
        }
        if (last != null) {
            this.addRunGroup(last);
        }
    }

    public String getContents() {
        return this.contents;
    }

    public Bidi getBidi() {
        return this.bidi;
    }

    public List<RunGroup> getRunGroupsInVisualOrder() {
        return ShapingRunSegmenter.reorderRunGroups(this.runGroups);
    }

    public boolean isRightToLeft() {
        return this.bidi.getParaLevel() % 2 != 0;
    }

    private void addRunGroup(List<Run> runs) {
        int firstBidiRunInGroup = this.currentBidiRun;
        int firstBidiStringIndex = this.currentBidiStringIndex;
        for (Run run : runs) {
            this.currentBidiStringIndex += run.text().length();
        }
        while (this.currentBidiRun < this.totalBidiRuns && this.bidi.getRunStart(this.currentBidiRun) < this.currentBidiStringIndex) {
            ++this.currentBidiRun;
        }
        if (this.currentBidiRun == this.totalBidiRuns || this.bidi.getRunStart(this.currentBidiRun) >= this.currentBidiStringIndex) {
            --this.currentBidiRun;
        }
        this.bidiRunsList.clear();
        for (int i = firstBidiRunInGroup; i <= this.currentBidiRun; ++i) {
            int c2;
            int start = Math.max(0, this.bidi.getRunStart(i) - firstBidiStringIndex);
            int end = Math.min(this.currentBidiStringIndex - firstBidiStringIndex, this.bidi.getRunLimit(i) - firstBidiStringIndex);
            if (end <= start) continue;
            int level = this.bidi.getRunLevel(i);
            int c = this.contents.codePointAt(firstBidiStringIndex + start);
            int script = UScript.getScript((int)c);
            for (int cur = start + Character.charCount(c); cur < end; cur += Character.charCount(c2)) {
                c2 = this.contents.codePointAt(firstBidiStringIndex + cur);
                int script2 = UScript.getScript((int)c2);
                if (ShapingRunSegmenter.isCommonOrInherited(script2) && ShapingRunSegmenter.includesScript(c2, script)) {
                    script2 = script;
                } else if (ShapingRunSegmenter.isCommonOrInherited(script) && ShapingRunSegmenter.includesScript(c, script2)) {
                    script = script2;
                }
                if (script == script2 || ShapingRunSegmenter.isCombiningMark(c)) continue;
                this.bidiRunsList.add(start);
                this.bidiRunsList.add(cur);
                this.bidiRunsList.add(level);
                this.bidiRunsList.add(ScriptTags.USCRIPT_VALUES_TO_TAGS[script]);
                start = cur;
                script = script2;
                c = c2;
            }
            this.bidiRunsList.add(start);
            this.bidiRunsList.add(end);
            this.bidiRunsList.add(level);
            this.bidiRunsList.add(ScriptTags.USCRIPT_VALUES_TO_TAGS[script]);
        }
        int[] bidiRuns = ShapingRunSegmenter.reorderBidiRuns(this.bidiRunsList);
        int runLevel = this.bidi.getRunLevel(firstBidiRunInGroup);
        RunGroup runGroup = new RunGroup(runs, runLevel, this.charOffset, bidiRuns, this.cache);
        this.runGroups.add(runGroup);
        this.charOffset += runGroup.getTotalLength();
        if (this.currentBidiRun < this.totalBidiRuns && this.currentBidiStringIndex >= this.bidi.getRunLimit(this.currentBidiRun)) {
            ++this.currentBidiRun;
        }
    }

    private static boolean isCombiningMark(int c) {
        int cat = UCharacter.getType((int)c);
        return cat == 8 || cat == 6 || cat == 7;
    }

    private static boolean isCommonOrInherited(int script) {
        return script == 0 || script == 1;
    }

    private static boolean includesScript(int codePoint, int script) {
        return UScript.hasScript((int)codePoint, (int)script) || UScript.hasScript((int)codePoint, (int)0) || UScript.hasScript((int)codePoint, (int)1);
    }

    private static int[] reorderBidiRuns(IntList runs) {
        int nRuns = runs.size() / 4;
        if (nRuns == 0) {
            return runs.toIntArray();
        }
        byte[] levels = new byte[nRuns];
        for (int i = 0; i < nRuns; ++i) {
            levels[i] = (byte)runs.getInt(4 * i + 2);
        }
        int[] indices = Bidi.reorderVisual((byte[])levels);
        int[] runsOut = new int[runs.size()];
        for (int i = 0; i < nRuns; ++i) {
            int j = indices[i];
            runsOut[4 * i + 0] = runs.getInt(4 * j + 0);
            runsOut[4 * i + 1] = runs.getInt(4 * j + 1);
            runsOut[4 * i + 2] = runs.getInt(4 * j + 2);
            runsOut[4 * i + 3] = runs.getInt(4 * j + 3);
        }
        return runsOut;
    }

    private static List<RunGroup> reorderRunGroups(List<RunGroup> runGroups) {
        int nRuns = runGroups.size();
        byte[] levels = new byte[nRuns];
        for (int i = 0; i < nRuns; ++i) {
            levels[i] = (byte)runGroups.get(i).getRunLevel();
        }
        Object[] runGroupsArray = runGroups.toArray(new RunGroup[0]);
        Bidi.reorderVisually((byte[])levels, (int)0, (Object[])runGroupsArray, (int)0, (int)nRuns);
        return List.of(runGroupsArray);
    }

    private static boolean areRunsCompatible(Run a, Run b) {
        return a.font() == b.font();
    }
}

