/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.caxton.layout;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.flirora.caxton.layout.RunGroup;
import xyz.flirora.caxton.layout.ShapingResult;

@OnlyIn(value=Dist.CLIENT)
public class Threshold {
    private int threshold;

    public Threshold(int threshold) {
        this.threshold = threshold;
    }

    public int getValue() {
        return this.threshold;
    }

    public boolean shouldSkip(RunGroup runGroup) {
        return this.threshold >= 0 && !runGroup.containsIndex(this.threshold);
    }

    public boolean updateLegacy(int index) {
        if (this.threshold >= 0 && this.threshold != index) {
            return true;
        }
        this.threshold = -1;
        return false;
    }

    public boolean updateCaxton(RunGroup runGroup, int bri, ShapingResult shapingResult, int sri) {
        int[] bidiRuns = runGroup.getBidiRuns();
        int start = bidiRuns[4 * bri + 0];
        int r0 = runGroup.getCharOffset() + start + shapingResult.clusterIndex(sri);
        int r1 = runGroup.getCharOffset() + start + shapingResult.clusterLimit(sri);
        if (this.threshold >= 0 && (r0 > this.threshold || this.threshold >= r1)) {
            return true;
        }
        this.threshold = -1;
        return false;
    }
}

